/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.necessities.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class Position {
    public static final Position ZERO = new Position(0.0, 0.0, 0.0, 0.0f, 0.0f, ResourceLocation.parse((String)"overworld"));
    public static final Codec<Position> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("X").forGetter(position -> position.x), (App)Codec.DOUBLE.fieldOf("Y").forGetter(position -> position.y), (App)Codec.DOUBLE.fieldOf("Z").forGetter(position -> position.z), (App)Codec.FLOAT.fieldOf("Yaw").forGetter(position -> Float.valueOf(position.yaw)), (App)Codec.FLOAT.fieldOf("Pitch").forGetter(position -> Float.valueOf(position.pitch)), (App)ResourceLocation.CODEC.fieldOf("Dimension").forGetter(position -> position.dimension)).apply((Applicative)instance, Position::new));
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;
    public ResourceLocation dimension;

    public Position(double x, double y, double z, float yaw, float pitch, ResourceLocation dimension) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.dimension = dimension;
    }

    public static Position deserialize(Dynamic<?> dynamic) {
        double x = dynamic.get("X").asDouble(0.0);
        double y = dynamic.get("Y").asDouble(0.0);
        double z = dynamic.get("Z").asDouble(0.0);
        float yaw = dynamic.get("Yaw").asFloat(0.0f);
        float pitch = dynamic.get("Pitch").asFloat(0.0f);
        ResourceLocation dimension = ResourceLocation.parse((String)dynamic.get("Dimension").asString("minecraft:overworld"));
        return new Position(x, y, z, yaw, pitch, dimension);
    }

    public static Position deserialize(CompoundTag tag) {
        double x = tag.getDouble("X").orElse(0.0);
        double y = tag.getDouble("Y").orElse(0.0);
        double z = tag.getDouble("Z").orElse(0.0);
        float yaw = tag.getFloat("Yaw").orElse(Float.valueOf(0.0f)).floatValue();
        float pitch = tag.getFloat("Pitch").orElse(Float.valueOf(0.0f)).floatValue();
        ResourceLocation dimension = ResourceLocation.parse((String)tag.getString("Dimension").orElse("minecraft:overworld"));
        return new Position(x, y, z, yaw, pitch, dimension);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("X", this.x);
        tag.putDouble("Y", this.y);
        tag.putDouble("Z", this.z);
        tag.putFloat("Yaw", this.yaw);
        tag.putFloat("Pitch", this.pitch);
        tag.putString("Dimension", this.dimension.toString());
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        boolean xEquals = Double.compare(position.x, this.x) == 0;
        boolean yEquals = Double.compare(position.y, this.y) == 0;
        boolean zEquals = Double.compare(position.z, this.z) == 0;
        boolean yawEquals = Float.compare(position.yaw, this.yaw) == 0;
        boolean pitchEquals = Float.compare(position.pitch, this.pitch) == 0;
        boolean dimensionEquals = this.dimension.equals((Object)position.dimension);
        return xEquals && yEquals && zEquals && yawEquals && pitchEquals && dimensionEquals;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, Float.valueOf(this.yaw), Float.valueOf(this.pitch), this.dimension);
    }
}

