/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.necessities.networking;

import com.daqem.necessities.Necessities;
import com.daqem.necessities.networking.clientbound.ClientboundNecessitiesHandshakePacket;
import com.daqem.necessities.networking.serverbound.ServerboundNecessitiesHandshakePacket;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public interface NecessitiesNetworking {
    public static final CustomPacketPayload.Type<ClientboundNecessitiesHandshakePacket> CLIENTBOUND_NECESSITIES_HANDSHAKE = new CustomPacketPayload.Type(Necessities.getId("clientbound_necessities_handshake"));
    public static final CustomPacketPayload.Type<ServerboundNecessitiesHandshakePacket> SERVERBOUND_NECESSITIES_HANDSHAKE = new CustomPacketPayload.Type(Necessities.getId("serverbound_necessities_handshake"));

    public static void initClient() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CLIENTBOUND_NECESSITIES_HANDSHAKE, ClientboundNecessitiesHandshakePacket.STREAM_CODEC, ClientboundNecessitiesHandshakePacket::handleClientSide);
    }

    public static void initCommon() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SERVERBOUND_NECESSITIES_HANDSHAKE, ServerboundNecessitiesHandshakePacket.STREAM_CODEC, ServerboundNecessitiesHandshakePacket::handleServerSide);
    }

    public static void initServer() {
        NetworkManager.registerS2CPayloadType(CLIENTBOUND_NECESSITIES_HANDSHAKE, ClientboundNecessitiesHandshakePacket.STREAM_CODEC);
    }

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> NecessitiesNetworking::initClient);
        EnvExecutor.runInEnv((Env)Env.SERVER, () -> NecessitiesNetworking::initServer);
        NecessitiesNetworking.initCommon();
    }
}

