/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.back;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.codedsakura.blossom.back.BlossomBackConfig;
import dev.codedsakura.blossom.back.BlossomLastDeath;
import dev.codedsakura.blossom.back.data.PlayerDeathData;
import dev.codedsakura.blossom.back.data.PlayerTeleportData;
import dev.codedsakura.blossom.back.data.ServerWorldSerializer;
import dev.codedsakura.blossom.lib.BlossomLib;
import dev.codedsakura.blossom.lib.config.BlossomConfig;
import dev.codedsakura.blossom.lib.config.ConfigManager;
import dev.codedsakura.blossom.lib.permissions.Permissions;
import dev.codedsakura.blossom.lib.teleport.TeleportConfig;
import dev.codedsakura.blossom.lib.teleport.TeleportUtils;
import dev.codedsakura.blossom.lib.text.TextUtils;
import dev.codedsakura.blossom.lib.utils.CustomLogger;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import org.apache.logging.log4j.core.Logger;

public class BlossomBack
implements ModInitializer {
    static BlossomBackConfig CONFIG = (BlossomBackConfig)ConfigManager.register(BlossomBackConfig.class, (String)"BlossomBack.json", newConfig -> {
        CONFIG = newConfig;
    });
    public static final Logger LOGGER = CustomLogger.createLogger((String)"BlossomBack");
    public static HashMap<UUID, TeleportUtils.TeleportDestination> DEATHS = new HashMap();
    static PlayerTeleportData teleportData;
    static PlayerDeathData deathData;

    public void onInitialize() {
        if (BlossomBack.CONFIG.lastDeath == null) {
            LOGGER.trace("updating config from 2.0.3 to ^2.1.0");
            BlossomBack.CONFIG.lastDeath = new BlossomBackConfig().lastDeath;
            BlossomBack.CONFIG.lastDeath.enabled = true;
            BlossomConfig.save((Object)CONFIG, (String)"BlossomBack.json");
            ConfigManager.refresh(BlossomBackConfig.class);
        }
        teleportData = new PlayerTeleportData();
        deathData = new PlayerDeathData();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ServerWorldSerializer.server = server;
        });
        TeleportUtils.addLastTeleportAddHook((player, destination, lastTeleportMap) -> BlossomBack.onPlayerTeleportHook());
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"back").requires(Permissions.require((String)"blossom.back", (boolean)true).and(p -> BlossomBack.CONFIG.back.enabled))).executes(this::runBack)));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lastdeath").requires(Permissions.require((String)"blossom.last-death", (boolean)true).and(p -> BlossomBack.CONFIG.lastDeath.enabled))).executes(this::runLastDeath)));
    }

    private int runBack(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        TeleportUtils.TeleportDestination destination = teleportData.get(player.method_5667());
        LOGGER.trace("back {} ({}) to {}", (Object)player.method_7334().getName(), (Object)player.method_5667(), (Object)destination);
        if (destination != null) {
            TeleportUtils.teleport((TeleportConfig)BlossomBack.CONFIG.back.teleportation, (double)BlossomBack.CONFIG.back.standStill, (long)BlossomBack.CONFIG.back.cooldown, BlossomBack.class, (class_3222)player, () -> destination);
        } else {
            TextUtils.sendErr(ctx, (String)"blossom.back.error.no-previous", (Object[])new Object[0]);
        }
        return 1;
    }

    private int runLastDeath(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        TeleportUtils.TeleportDestination destination = deathData.get(player.method_5667());
        LOGGER.trace("back (death) {} ({}) to {}", (Object)player.method_7334().getName(), (Object)player.method_5667(), (Object)destination);
        if (destination != null) {
            TeleportUtils.teleport((TeleportConfig)BlossomBack.CONFIG.lastDeath.teleportation, (double)BlossomBack.CONFIG.lastDeath.standStill, (long)BlossomBack.CONFIG.lastDeath.cooldown, BlossomBack.CONFIG.separateCooldowns ? BlossomLastDeath.class : BlossomBack.class, (class_3222)player, () -> destination);
        } else {
            TextUtils.sendErr(ctx, (String)"blossom.back.error.no-death", (Object[])new Object[0]);
        }
        return 1;
    }

    public static void onPlayerDeathHook() {
        if (!BlossomBack.CONFIG.persistLastDeath) {
            return;
        }
        LOGGER.trace("persisting deaths");
        deathData.updateData();
    }

    public static void onPlayerTeleportHook() {
        if (!BlossomBack.CONFIG.persistBack) {
            return;
        }
        LOGGER.trace("persisting teleports");
        teleportData.updateData();
    }
}

