/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab;

import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.api.DetailArmorBarAPI;
import com.redlimerl.detailab.api.render.ArmorBarRenderManager;
import com.redlimerl.detailab.api.render.ItemBarRenderManager;
import com.redlimerl.detailab.api.render.TextureOffset;
import com.redlimerl.detailab.config.DABForgeConfig;
import com.redlimerl.detailab.screen.OptionsScreen;
import java.awt.Color;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ClientInitializer {
    public static final ResourceLocation GUI_ARMOR_BAR = new ResourceLocation("detailab", "textures/armor_bar.png");
    private static final String[] compatibilityMods = new String[]{"healthoverlay"};
    private static final TextureOffset outline = new TextureOffset(9, 0);
    private static final TextureOffset outlineHalf = new TextureOffset(27, 0);

    public static void onClientSetup() {
        ClientInitializer.initializeModFeatures();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DABForgeConfig.SPEC);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new OptionsScreen((Screen)screen)));
    }

    private static void initializeModFeatures() {
        ClientInitializer.customArmorBar(new ArmorItem[]{(ArmorItem)Items.f_42480_, (ArmorItem)Items.f_42482_, (ArmorItem)Items.f_42481_, (ArmorItem)Items.f_42483_}, 9, 0);
        ClientInitializer.customArmorBar(new ArmorItem[]{(ArmorItem)Items.f_42472_, (ArmorItem)Items.f_42474_, (ArmorItem)Items.f_42473_, (ArmorItem)Items.f_42475_}, 27, 18);
        ClientInitializer.customArmorBar(new ArmorItem[]{(ArmorItem)Items.f_42354_}, 45, 36);
        ClientInitializer.customArmorBar(new ArmorItem[]{(ArmorItem)Items.f_42468_, (ArmorItem)Items.f_42470_, (ArmorItem)Items.f_42469_, (ArmorItem)Items.f_42471_}, 63, 54);
        ClientInitializer.customArmorBar(new ArmorItem[]{(ArmorItem)Items.f_42464_, (ArmorItem)Items.f_42466_, (ArmorItem)Items.f_42465_, (ArmorItem)Items.f_42467_}, 81, 72);
        ClientInitializer.customArmorBar(new ArmorItem[]{(ArmorItem)Items.f_42476_, (ArmorItem)Items.f_42478_, (ArmorItem)Items.f_42477_, (ArmorItem)Items.f_42479_}, 99, 90);
        ClientInitializer.customArmorBar(new ArmorItem[]{(ArmorItem)Items.f_42407_, (ArmorItem)Items.f_42462_, (ArmorItem)Items.f_42408_, (ArmorItem)Items.f_42463_}, 117, 108);
        DetailArmorBarAPI.customItemBarBuilder().item(Items.f_42741_).render(itemStack -> {
            if (itemStack.m_41720_() instanceof DyeableLeatherItem) {
                int colorValue = ClientInitializer.getElytraColor(itemStack);
                return new ItemBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(36, 0), new TextureOffset(54, 0), true, new Color(colorValue));
            }
            return new ItemBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(36, 0), new TextureOffset(54, 0), true, Color.WHITE);
        }).register();
        for (String compatibilityMod : compatibilityMods) {
            if (!ModList.get().getModObjectById(compatibilityMod).isPresent()) continue;
            DetailArmorBar.getConfig().getOptions().toggleCompatibleHeartMod = true;
        }
    }

    private static void customArmorBar(ArmorItem[] armors, int x_full, int x_half) {
        DetailArmorBarAPI.customArmorBarBuilder().armor(armors).render(itemStack -> {
            Item patt4149$temp = itemStack.m_41720_();
            if (patt4149$temp instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeableItem = (DyeableLeatherItem)patt4149$temp;
                int colorValue = dyeableItem.m_41121_(itemStack);
                return ClientInitializer.createRenderManager(x_full, x_half, new Color(colorValue));
            }
            return ClientInitializer.createRenderManager(x_full, x_half, Color.WHITE);
        }).register();
    }

    private static ArmorBarRenderManager createRenderManager(int x_full, int x_half, Color color) {
        int textureOffset = 9 + DetailArmorBar.isVanillaTexture();
        return new ArmorBarRenderManager(GUI_ARMOR_BAR, 128, 128, new TextureOffset(x_full, textureOffset), new TextureOffset(x_half, textureOffset), outline, outlineHalf, color);
    }

    private static int getElytraColor(ItemStack pStack) {
        CompoundTag $$1 = pStack.m_41737_("display");
        return $$1 != null && $$1.m_128425_("color", 99) ? $$1.m_128451_("color") : 0x808080;
    }
}

