/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.api.render;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.redlimerl.detailab.ClientInitializer;
import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.api.render.ArmorBarRenderManager;
import com.redlimerl.detailab.api.render.BarRenderManager;
import com.redlimerl.detailab.api.render.ItemBarRenderManager;
import com.redlimerl.detailab.api.render.TextureOffset;
import com.redlimerl.detailab.render.InGameDrawer;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class CustomArmorBar {
    private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("detailab", "textures/armor_trim.png");
    private static final Map<ResourceLocation, ResourceLocation> COLORED_TRIM_CACHE = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Map<ResourceLocation, Color[]> PALETTE_CACHE = new HashMap<ResourceLocation, Color[]>();
    public static CustomArmorBar DEFAULT = new CustomArmorBar(itemStack -> new ArmorBarRenderManager(ClientInitializer.GUI_ARMOR_BAR, 128, 128, new TextureOffset(63, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(54, 9 + DetailArmorBar.isVanillaTexture()), new TextureOffset(9, 0), new TextureOffset(27, 0)));
    public static CustomArmorBar EMPTY = new CustomArmorBar(itemStack -> {
        if (DetailArmorBar.getConfig().getOptions().toggleEmptyBar) {
            return new ArmorBarRenderManager(ClientInitializer.GUI_ARMOR_BAR, 128, 128, new TextureOffset(45, 0), new TextureOffset(45, 0), new TextureOffset(9, 0), new TextureOffset(27, 0));
        }
        return new ArmorBarRenderManager(ClientInitializer.GUI_ARMOR_BAR, 128, 128, new TextureOffset(0, 0), new TextureOffset(0, 0), new TextureOffset(0, 0), new TextureOffset(0, 0));
    });
    private final Function<ItemStack, ? extends BarRenderManager> predicate;

    public CustomArmorBar(Function<ItemStack, ? extends BarRenderManager> predicate) {
        this.predicate = predicate;
    }

    public void draw(ItemStack itemStack, PoseStack matrices, int xPos, int yPos, boolean isHalf, boolean isMirror) {
        BarRenderManager renderInfo = this.predicate.apply(itemStack);
        if (renderInfo.isShown()) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)renderInfo.getTexture());
        if (isHalf) {
            InGameDrawer.drawTexture(matrices, xPos, yPos, renderInfo.getTextureOffsetHalf().x(), renderInfo.getTextureOffsetHalf().y(), renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), renderInfo.getColor(), isMirror);
        } else {
            InGameDrawer.drawTexture(matrices, xPos, yPos, renderInfo.getTextureOffsetFull().x(), renderInfo.getTextureOffsetFull().y(), renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), renderInfo.getColor(), false);
        }
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        if (server != null && ArmorTrim.m_266285_((RegistryAccess)server.m_206579_(), (ItemStack)itemStack).isPresent()) {
            TrimMaterial material = (TrimMaterial)((ArmorTrim)ArmorTrim.m_266285_((RegistryAccess)server.m_206579_(), (ItemStack)itemStack).get()).m_266210_().get();
            this.renderTrimOverlay(material, matrices, xPos, yPos, isHalf, isMirror, itemStack.m_41720_() instanceof ElytraItem);
        }
    }

    private void renderTrimOverlay(TrimMaterial material, PoseStack matrices, int xPos, int yPos, boolean isHalf, boolean isMirror, boolean isElytra) {
        String materialName;
        ResourceLocation location = new ResourceLocation(material.f_265854_());
        ResourceLocation coloredOverlay = this.getColoredOverlayTexture(location, materialName = location.m_135815_().substring(location.m_135815_().lastIndexOf(47) + 1));
        if (coloredOverlay == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)coloredOverlay);
        int textureWidth = 18;
        int textureHeight = 18;
        if (isElytra) {
            InGameDrawer.drawTexture(matrices, xPos, yPos, 0, 9, textureWidth, textureHeight, Color.WHITE, false);
        } else if (isHalf) {
            InGameDrawer.drawTexture(matrices, xPos, yPos, 9, 0, textureWidth, textureHeight, Color.WHITE, isMirror);
        } else {
            InGameDrawer.drawTexture(matrices, xPos, yPos, 0, 0, textureWidth, textureHeight, Color.WHITE, false);
        }
    }

    private ResourceLocation getColoredOverlayTexture(ResourceLocation location, String materialName) {
        if (COLORED_TRIM_CACHE.containsKey(location)) {
            return COLORED_TRIM_CACHE.get(location);
        }
        Color[] palette = this.loadPaletteColors(location, materialName);
        if (palette == null) {
            DetailArmorBar.LOGGER.error("Failed to load palette for material: {}", (Object)location);
            return null;
        }
        try {
            NativeImage overlayImage;
            Resource resource = Minecraft.m_91087_().m_91098_().m_213713_(OVERLAY_TEXTURE).orElse(null);
            if (resource == null) {
                DetailArmorBar.LOGGER.error("Overlay texture not found: {}", (Object)OVERLAY_TEXTURE);
                return null;
            }
            try (InputStream stream = resource.m_215507_();){
                overlayImage = NativeImage.m_85058_((InputStream)stream);
            }
            int width = overlayImage.m_84982_();
            int height = overlayImage.m_85084_();
            NativeImage coloredImage = new NativeImage(width, height, false);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int argb = overlayImage.m_84985_(x, y);
                    int newColor = CustomArmorBar.getNewColor(argb, palette);
                    coloredImage.m_84988_(x, y, newColor);
                }
            }
            DynamicTexture dynamicTexture = new DynamicTexture(coloredImage);
            ResourceLocation textureId = new ResourceLocation("detailab", "colored_trim_" + location.m_135827_() + "_" + location.m_135815_().replace('/', '_'));
            Minecraft.m_91087_().m_91097_().m_118495_(textureId, (AbstractTexture)dynamicTexture);
            COLORED_TRIM_CACHE.put(location, textureId);
            overlayImage.close();
            return textureId;
        }
        catch (IOException e) {
            DetailArmorBar.LOGGER.error("Failed to generate colored trim texture", (Throwable)e);
            return null;
        }
    }

    private static int getNewColor(int argb, Color[] palette) {
        int index;
        int a = FastColor.ABGR32.m_266503_((int)argb);
        int r = FastColor.ABGR32.m_266313_((int)argb);
        int g = FastColor.ABGR32.m_266446_((int)argb);
        int b = FastColor.ABGR32.m_266247_((int)argb);
        int gray = (r + g + b) / 3;
        switch (gray) {
            case 0: {
                index = 7;
                break;
            }
            case 32: {
                index = 6;
                break;
            }
            case 64: {
                index = 5;
                break;
            }
            case 96: {
                index = 4;
                break;
            }
            case 128: {
                index = 3;
                break;
            }
            case 160: {
                index = 2;
                break;
            }
            case 192: {
                index = 1;
                break;
            }
            case 224: {
                index = 0;
                break;
            }
            default: {
                return 0;
            }
        }
        Color paletteColor = palette[index];
        return FastColor.ABGR32.m_266248_((int)a, (int)paletteColor.getBlue(), (int)paletteColor.getGreen(), (int)paletteColor.getRed());
    }

    private Color[] loadPaletteColors(ResourceLocation materialId, String materialName) {
        if (PALETTE_CACHE.containsKey(materialId)) {
            return PALETTE_CACHE.get(materialId);
        }
        ResourceLocation paletteTexture = new ResourceLocation(materialId.m_135827_(), "textures/trims/color_palettes/" + materialName + ".png");
        Color[] palette = new Color[8];
        try {
            NativeImage paletteImage;
            Resource resource = Minecraft.m_91087_().m_91098_().m_213713_(paletteTexture).orElse(null);
            if (resource == null) {
                DetailArmorBar.LOGGER.error("Palette texture not found: {}", (Object)paletteTexture);
                return null;
            }
            try (InputStream stream = resource.m_215507_();){
                paletteImage = NativeImage.m_85058_((InputStream)stream);
            }
            if (paletteImage.m_84982_() < 8 || paletteImage.m_85084_() < 1) {
                DetailArmorBar.LOGGER.error("Invalid palette texture size: {}x{}", (Object)paletteImage.m_84982_(), (Object)paletteImage.m_85084_());
                paletteImage.close();
                return null;
            }
            for (int i = 0; i < 8; ++i) {
                int rgb = paletteImage.m_84985_(i, 0);
                palette[i] = new Color(FastColor.ABGR32.m_266313_((int)rgb), FastColor.ABGR32.m_266446_((int)rgb), FastColor.ABGR32.m_266247_((int)rgb));
            }
            PALETTE_CACHE.put(materialId, palette);
            paletteImage.close();
            return palette;
        }
        catch (IOException e) {
            DetailArmorBar.LOGGER.error("Failed to load palette texture", (Throwable)e);
            return null;
        }
    }

    public void drawOutLine(ItemStack itemStack, PoseStack matrices, int xPos, int yPos, boolean isHalf, boolean isMirror, Color color) {
        BarRenderManager renderInfo = this.predicate.apply(itemStack);
        if (renderInfo.isShown()) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)renderInfo.getTexture());
        if (isHalf) {
            if (renderInfo instanceof ItemBarRenderManager) {
                InGameDrawer.drawTexture(matrices, xPos + 4, yPos, renderInfo.getTextureOffsetOutlineHalf().x() + 4, renderInfo.getTextureOffsetOutlineHalf().y(), 5, 9, renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), color, false);
            } else {
                InGameDrawer.drawTexture(matrices, xPos, yPos, renderInfo.getTextureOffsetOutlineHalf().x(), renderInfo.getTextureOffsetOutlineHalf().y(), renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), color, isMirror);
            }
        } else {
            InGameDrawer.drawTexture(matrices, xPos, yPos, renderInfo.getTextureOffsetOutline().x(), renderInfo.getTextureOffsetOutline().y(), renderInfo.getTextureWidth(), renderInfo.getTextureHeight(), color, false);
        }
    }
}

