/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.render;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.redlimerl.detailab.ClientInitializer;
import com.redlimerl.detailab.DetailArmorBar;
import com.redlimerl.detailab.api.DetailArmorBarAPI;
import com.redlimerl.detailab.api.render.CustomArmorBar;
import com.redlimerl.detailab.config.ConfigEnumType;
import com.redlimerl.detailab.render.InGameDrawer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ArmorBarRenderer {
    public static final ArmorBarRenderer INSTANCE = new ArmorBarRenderer();
    public static long LAST_THORNS = 0L;
    public static long LAST_MENDING = 0L;
    private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final Minecraft client = Minecraft.m_91087_();
    private final Gui hud;

    public ArmorBarRenderer() {
        this.hud = this.client.f_91065_;
    }

    private static int getAnimationSpeed() {
        return switch (DetailArmorBar.getConfig().getOptions().effectSpeed) {
            case ConfigEnumType.EffectSpeed.VERY_SLOW -> 45;
            case ConfigEnumType.EffectSpeed.SLOW -> 37;
            case ConfigEnumType.EffectSpeed.FAST -> 23;
            case ConfigEnumType.EffectSpeed.VERY_FAST -> 15;
            default -> 30;
        };
    }

    private static float lerp(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    private static Color getProtectColor(int g, int p, int e, int f, int a) {
        long time;
        int speed = ArmorBarRenderer.getAnimationSpeed();
        int alpha = DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.AURA ? 80 : (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.OUTLINE ? ((time = DetailArmorBar.getTicks()) % ((long)speed * 4L) < (long)speed * 2L ? 0 : (time % ((long)speed * 2L) < (long)speed ? Math.round(ArmorBarRenderer.lerp((float)(time % (long)speed) / ((float)speed - 1.0f), 0.0f, 0.65f) * 255.0f) : Math.round(ArmorBarRenderer.lerp((float)(time % (long)speed) / ((float)speed - 1.0f), 0.65f, 0.0f) * 255.0f))) : 0);
        if (g > 0) {
            return new Color(153, 255, 255, alpha);
        }
        if (p > 0) {
            return new Color(112, 51, 173, alpha);
        }
        if (e > 0) {
            return new Color(255, 255, 0, alpha);
        }
        if (f > 0) {
            return new Color(210, 56, 0, alpha);
        }
        if (a > 0) {
            return new Color(255, 255, 255, alpha);
        }
        return Color.WHITE;
    }

    private static Color getProtectColor(int[] s) {
        return ArmorBarRenderer.getProtectColor(s[0], s[1], s[2], s[3], s[4]);
    }

    private static Color getLowDurabilityColor() {
        int speed = ArmorBarRenderer.getAnimationSpeed();
        long time = DetailArmorBar.getTicks();
        int alpha = time % ((long)speed * 4L) >= (long)speed * 2L ? 0 : (time % ((long)speed * 2L) < (long)speed ? Math.round(ArmorBarRenderer.lerp((float)(time % (long)speed) / ((float)speed - 1.0f), 0.0f, 0.65f) * 255.0f) : Math.round(ArmorBarRenderer.lerp((float)(time % (long)speed) / ((float)speed - 1.0f), 0.65f, 0.0f) * 255.0f));
        return new Color(255, 25, 25, alpha);
    }

    private static Color getThornColor() {
        long time = DetailArmorBar.getTicks() - LAST_THORNS;
        if (DetailArmorBar.getConfig().getOptions().effectThorn == ConfigEnumType.Animation.STATIC) {
            return Color.WHITE;
        }
        if (time > 19L) {
            return Color.WHITE;
        }
        int cc = Math.round(ArmorBarRenderer.lerp((float)(time % 20L) / 19.0f, 0.0f, 1.0f) * 255.0f);
        return new Color(255, cc, cc);
    }

    private static Map<Enchantment, LevelData> getEnchantments(Iterable<ItemStack> equipment) {
        HashMap<Enchantment, LevelData> result = new HashMap<Enchantment, LevelData>();
        for (ItemStack itemStack : equipment) {
            if (itemStack.m_41619_()) continue;
            EnchantmentHelper.m_44831_((ItemStack)itemStack).forEach((enchantment, integer) -> {
                LevelData enchantData = result.getOrDefault(enchantment, new LevelData(0, 0));
                ++enchantData.count;
                enchantData.level += integer.intValue();
                if (enchantment == Enchantments.f_44972_) {
                    enchantData.level += integer - 1;
                }
                result.put((Enchantment)enchantment, enchantData);
            });
        }
        return result;
    }

    private static LevelData getEnchantLevel(Iterable<ItemStack> equipment, Enchantment type) {
        return ArmorBarRenderer.getEnchantments(equipment).getOrDefault(type, new LevelData(0, 0));
    }

    private int getLowDurabilityItem(Iterable<ItemStack> equipment) {
        int count = 0;
        for (ItemStack itemStack : equipment) {
            if (itemStack.m_41619_() || itemStack.m_41776_() == 0 || !((float)itemStack.m_41773_() * 100.0f / ((float)itemStack.m_41776_() * 100.0f) >= 0.92f)) continue;
            count += itemStack.m_41720_() instanceof ArmorItem ? ArmorBarRenderer.getDefense(itemStack) : 2;
        }
        return count;
    }

    private static List<Pair<ItemStack, CustomArmorBar>> getArmorPoints(Player player) {
        ArrayList<Pair<ItemStack, CustomArmorBar>> armorItem = new ArrayList<Pair<ItemStack, CustomArmorBar>>();
        Stack<ItemStack> equipment = new Stack<ItemStack>();
        for (ItemStack item : player.m_6168_()) {
            if (DetailArmorBar.getConfig().getOptions().toggleInverseSlot) {
                equipment.push(item);
                continue;
            }
            equipment.add(0, item);
        }
        AttributeInstance attribute = player.m_21051_(Attributes.f_22284_);
        if (attribute != null) {
            int i = 0;
            while ((double)i < attribute.m_22115_()) {
                armorItem.add((Pair<ItemStack, CustomArmorBar>)new Pair((Object)ItemStack.f_41583_, (Object)CustomArmorBar.DEFAULT));
                ++i;
            }
            for (AttributeModifier entityAttributeModifier : attribute.m_22122_()) {
                if (Arrays.stream(MODIFIERS).toList().contains(entityAttributeModifier.m_22209_())) continue;
                int i2 = 0;
                while ((double)i2 < entityAttributeModifier.m_22218_()) {
                    armorItem.add((Pair<ItemStack, CustomArmorBar>)new Pair((Object)ItemStack.f_41583_, (Object)CustomArmorBar.DEFAULT));
                    ++i2;
                }
            }
        }
        for (ItemStack itemStack : equipment) {
            CustomArmorBar barData;
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                barData = DetailArmorBar.getConfig().getOptions().toggleArmorTypes ? DetailArmorBarAPI.getArmorBarList().getOrDefault(armor, CustomArmorBar.DEFAULT) : (DetailArmorBar.getConfig().getOptions().toggleNetherites && armor.m_40401_() == ArmorMaterials.NETHERITE ? DetailArmorBarAPI.getArmorBarList().getOrDefault(armor, CustomArmorBar.DEFAULT) : CustomArmorBar.DEFAULT);
                for (int i = 0; i < ArmorBarRenderer.getDefense(itemStack); ++i) {
                    armorItem.add((Pair<ItemStack, CustomArmorBar>)new Pair((Object)itemStack, (Object)barData));
                }
                continue;
            }
            if (!DetailArmorBar.getConfig().getOptions().toggleItemBar || DetailArmorBar.getConfig().getOptions().toggleSortSpecialItem || !DetailArmorBarAPI.getItemBarList().containsKey(itemStack.m_41720_())) continue;
            if (armorItem.size() % 2 == 1) {
                armorItem.add((Pair<ItemStack, CustomArmorBar>)new Pair((Object)ItemStack.f_41583_, (Object)CustomArmorBar.EMPTY));
            }
            barData = DetailArmorBarAPI.getItemBarList().get(itemStack.m_41720_());
            armorItem.add((Pair<ItemStack, CustomArmorBar>)new Pair((Object)itemStack, (Object)barData));
            armorItem.add((Pair<ItemStack, CustomArmorBar>)new Pair((Object)itemStack, (Object)barData));
        }
        if (DetailArmorBar.getConfig().getOptions().toggleItemBar && DetailArmorBar.getConfig().getOptions().toggleSortSpecialItem) {
            for (ItemStack itemStack : equipment) {
                if (itemStack.m_41619_() || itemStack.m_41720_() instanceof ArmorItem || !DetailArmorBarAPI.getItemBarList().containsKey(itemStack.m_41720_())) continue;
                if (armorItem.size() % 2 == 1) {
                    armorItem.add((Pair<ItemStack, CustomArmorBar>)new Pair((Object)ItemStack.f_41583_, (Object)CustomArmorBar.EMPTY));
                }
                CustomArmorBar barData = DetailArmorBarAPI.getItemBarList().get(itemStack.m_41720_());
                armorItem.add((Pair<ItemStack, CustomArmorBar>)new Pair((Object)itemStack, (Object)barData));
                armorItem.add((Pair<ItemStack, CustomArmorBar>)new Pair((Object)itemStack, (Object)barData));
            }
        }
        return armorItem;
    }

    private static int getDefense(ItemStack itemStack) {
        ArmorItem armorItem = (ArmorItem)itemStack.m_41720_();
        Multimap attributes = itemStack.m_41638_(armorItem.m_40402_());
        if (attributes.containsKey((Object)Attributes.f_22284_)) {
            return attributes.get((Object)Attributes.f_22284_).stream().filter(att -> Arrays.stream(MODIFIERS).toList().contains(att.m_22209_())).mapToInt(att -> (int)att.m_22218_()).sum();
        }
        return armorItem.m_40404_();
    }

    public void render(PoseStack matrices, Player player) {
        int mendingSpeed;
        long mendingTime;
        this.client.m_91307_().m_6182_("armor");
        LevelData generic = ArmorBarRenderer.getEnchantLevel(player.m_6168_(), Enchantments.f_44965_);
        LevelData projectile = ArmorBarRenderer.getEnchantLevel(player.m_6168_(), Enchantments.f_44969_);
        LevelData explosive = ArmorBarRenderer.getEnchantLevel(player.m_6168_(), Enchantments.f_44968_);
        LevelData fire = ArmorBarRenderer.getEnchantLevel(player.m_6168_(), Enchantments.f_44966_);
        int[] protectArr = new int[]{generic.level + generic.count, projectile.level, explosive.level, fire.level, 0};
        List<Pair<ItemStack, CustomArmorBar>> armorPoints = ArmorBarRenderer.getArmorPoints(player);
        LevelData thorns = ArmorBarRenderer.getEnchantLevel(player.m_6168_(), Enchantments.f_44972_);
        double playerHealth = Math.ceil(player.m_21223_());
        int totalArmorPoint = armorPoints.size();
        int totalEnchants = Arrays.stream(protectArr).sum();
        double maxHealth = Math.max(player.m_21133_(Attributes.f_22276_), playerHealth);
        double absorptionHealth = Math.ceil(player.m_6103_());
        int healthRow = DetailArmorBar.getConfig().getOptions().toggleCompatibleHeartMod ? 1 : (int)Math.ceil((maxHealth + absorptionHealth) / 20.0);
        int screenWidth = this.client.m_91268_().m_85445_() / 2 - 91;
        int screenHeight = this.client.m_91268_().m_85446_() - 39;
        int yPos = screenHeight - (healthRow - 1) * Math.max(10 - (healthRow - 2), 3) - 10;
        int stackCount = (totalArmorPoint - 1) / 20;
        int stackRow = stackCount * 20;
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        if (totalArmorPoint > 0) {
            for (int count = 0; count < 10; ++count) {
                int xPos = screenWidth + count * 8;
                if (count * 2 + 1 + stackRow < totalArmorPoint) {
                    Pair<ItemStack, CustomArmorBar> am1 = armorPoints.get(count * 2 + stackRow);
                    Pair<ItemStack, CustomArmorBar> am2 = armorPoints.get(count * 2 + 1 + stackRow);
                    if (am1.getSecond() == am2.getSecond()) {
                        ((CustomArmorBar)am1.getSecond()).draw((ItemStack)am1.getFirst(), matrices, xPos, yPos, false, false);
                    } else {
                        ((CustomArmorBar)am2.getSecond()).draw((ItemStack)am2.getFirst(), matrices, xPos, yPos, true, true);
                        ((CustomArmorBar)am1.getSecond()).draw((ItemStack)am1.getFirst(), matrices, xPos, yPos, true, false);
                    }
                }
                if (count * 2 + 1 + stackRow == totalArmorPoint) {
                    CustomArmorBar.EMPTY.draw(ItemStack.f_41583_, matrices, xPos, yPos, false, false);
                    Pair<ItemStack, CustomArmorBar> am = armorPoints.get(count * 2 + stackRow);
                    ((CustomArmorBar)am.getSecond()).draw((ItemStack)am.getFirst(), matrices, xPos, yPos, true, false);
                }
                if (count * 2 + 1 + stackRow <= totalArmorPoint) continue;
                CustomArmorBar.EMPTY.draw(ItemStack.f_41583_, matrices, xPos, yPos, false, false);
            }
            if (armorPoints.size() > 20) {
                for (int i = 0; i < stackCount; ++i) {
                    CustomArmorBar.DEFAULT.draw(ItemStack.f_41583_, matrices, screenWidth - 7 - (stackCount - i) * 3, yPos, false, false);
                }
            }
        }
        if (DetailArmorBar.getConfig().getOptions().toggleDurability) {
            Color lowDurColor;
            int lowDur = this.getLowDurabilityItem(player.m_6168_());
            if (totalArmorPoint != 0 && lowDur != 0 && (lowDurColor = ArmorBarRenderer.getLowDurabilityColor()).getAlpha() != 0) {
                int armorPreset = (totalArmorPoint - 1) % 20 + 1;
                int halfArmors = (int)Math.ceil((double)armorPreset / 2.0) - 1;
                for (int count = 0; count <= halfArmors && lowDur != 0; ++count) {
                    int xPos = screenWidth + (halfArmors - count) * 8;
                    Pair<ItemStack, CustomArmorBar> am = armorPoints.get((halfArmors - count) * 2 + stackRow);
                    if (armorPreset == (halfArmors - count) * 2 + 1) {
                        if (count != 0) continue;
                        ((CustomArmorBar)am.getSecond()).drawOutLine((ItemStack)am.getFirst(), matrices, xPos, yPos, true, false, lowDurColor);
                        --lowDur;
                        continue;
                    }
                    if (lowDur == 1) {
                        ((CustomArmorBar)am.getSecond()).drawOutLine((ItemStack)am.getFirst(), matrices, xPos, yPos, true, true, lowDurColor);
                        lowDur = 0;
                        continue;
                    }
                    ((CustomArmorBar)am.getSecond()).drawOutLine((ItemStack)am.getFirst(), matrices, xPos, yPos, false, false, lowDurColor);
                    lowDur -= 2;
                }
            }
        }
        if (DetailArmorBar.getConfig().getOptions().toggleMending && totalArmorPoint != 0 && (mendingTime = DetailArmorBar.getTicks() - LAST_MENDING) < (long)((mendingSpeed = 3) * 4)) {
            for (int count = 0; count < 10; ++count) {
                if (mendingTime % (long)(mendingSpeed * 2) >= (long)mendingSpeed) continue;
                int xPos = screenWidth + count * 8;
                if (armorPoints.size() <= count * 2 + stackRow) {
                    if (!DetailArmorBar.getConfig().getOptions().toggleEmptyBar) continue;
                    CustomArmorBar.DEFAULT.drawOutLine(ItemStack.f_41583_, matrices, xPos, yPos, false, false, Color.WHITE);
                    continue;
                }
                Pair<ItemStack, CustomArmorBar> am = armorPoints.get(count * 2 + stackRow);
                ((CustomArmorBar)am.getSecond()).drawOutLine((ItemStack)am.getFirst(), matrices, xPos, yPos, false, false, Color.WHITE);
            }
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientInitializer.GUI_ARMOR_BAR);
        if (DetailArmorBar.getConfig().getOptions().toggleEnchants && totalEnchants > 0 && totalArmorPoint > 0) {
            for (int count = 0; count * 2 + 1 <= totalEnchants && count <= 9; ++count) {
                int xPos = screenWidth + count * 8;
                if (count * 2 + 1 < totalEnchants) {
                    int min = -1;
                    int max = -1;
                    for (int pw = 0; pw < 5; ++pw) {
                        if (min == -1 && protectArr[pw] > 1) {
                            min = pw;
                            break;
                        }
                        if (min == -1 && protectArr[pw] == 1) {
                            min = pw;
                            continue;
                        }
                        if (min == -1 || max != -1 || protectArr[pw] < 1) continue;
                        max = pw;
                    }
                    if (min != -1 && max != -1) {
                        this.drawEnchantTexture(matrices, xPos, yPos, ArmorBarRenderer.getProtectColor(protectArr), 2);
                        protectArr[min] = 0;
                        this.drawEnchantTexture(matrices, xPos, yPos, ArmorBarRenderer.getProtectColor(protectArr), 1);
                        int n = max;
                        protectArr[n] = protectArr[n] - 1;
                    } else {
                        this.drawEnchantTexture(matrices, xPos, yPos, ArmorBarRenderer.getProtectColor(protectArr), 0);
                        int n = min;
                        protectArr[n] = protectArr[n] - 2;
                    }
                }
                if (count * 2 + 1 != totalEnchants) continue;
                this.drawEnchantTexture(matrices, xPos, yPos, ArmorBarRenderer.getProtectColor(protectArr), 2);
            }
        }
        if (DetailArmorBar.getConfig().getOptions().toggleThorns && thorns.level > 0 && totalArmorPoint > 0) {
            Color thornsColor = ArmorBarRenderer.getThornColor();
            for (int count = 0; count < 10 && count * 2 + 1 <= thorns.level; ++count) {
                int xPos = screenWidth + count * 8;
                if (count * 2 + 1 < thorns.level) {
                    InGameDrawer.drawTexture(matrices, xPos, yPos, 36, 18, thornsColor, false);
                }
                if (count * 2 + 1 != thorns.level) continue;
                InGameDrawer.drawTexture(matrices, xPos, yPos, 27, 18, thornsColor, false);
            }
        }
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Gui.f_279580_);
    }

    private void drawEnchantTexture(PoseStack matrices, int x, int y, Color color, int half) {
        int u = 0;
        int v = 0;
        int t = this.hud.m_93079_() / 3 % 36;
        if (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.AURA) {
            if (t < 12) {
                u = t % 12 * 9;
                v = 27 + half * 9;
            }
        } else if (DetailArmorBar.getConfig().getOptions().effectType == ConfigEnumType.ProtectionEffect.OUTLINE) {
            u = 9 + half * 9;
        } else {
            return;
        }
        InGameDrawer.drawTexture(matrices, x, y, u, v, color, false);
    }

    static class LevelData {
        int level;
        int count;

        LevelData(int level, int count) {
            this.level = level;
            this.count = count;
        }
    }
}

