/*
 * Decompiled with CFR 0.152.
 */
package com.redlimerl.detailab.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class InGameDrawer {
    public static void drawTexture(PoseStack matrices, int x, int y, int u, int v, Color color, boolean mirror) {
        InGameDrawer.drawTexture(matrices, x, y, u, v, 128, 128, color, mirror);
    }

    public static void drawTexture(PoseStack matrices, int x, int y, int u, int v, int width, int height, Color color, boolean mirror) {
        InGameDrawer.drawTexture(matrices, x, y, u, v, 9, 9, width, height, color, mirror);
    }

    public static void drawTexture(PoseStack matrices, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, Color color, boolean mirror) {
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 100.0f));
        InGameDrawer.drawTexture(matrices, x, y, width, height, u, v, width, height, textureWidth, textureHeight, mirror);
    }

    public static void drawTexture(PoseStack matrices, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight, boolean mirror) {
        InGameDrawer.drawTexture(matrices, x, x + width, y, y + height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight, mirror);
    }

    private static void drawTexture(PoseStack matrices, int x0, int y0, int x1, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight, boolean mirror) {
        InGameDrawer.drawTexturedQuad(matrices.m_85850_().m_252922_(), x0, y0, x1, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight, mirror);
    }

    private static void drawTexturedQuad(Matrix4f matrices, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, boolean mirror) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        if (mirror) {
            bufferBuilder.m_252986_(matrices, (float)x0, (float)y1, (float)z).m_7421_(u1, v1).m_5752_();
            bufferBuilder.m_252986_(matrices, (float)x1, (float)y1, (float)z).m_7421_(u0, v1).m_5752_();
            bufferBuilder.m_252986_(matrices, (float)x1, (float)y0, (float)z).m_7421_(u0, v0).m_5752_();
            bufferBuilder.m_252986_(matrices, (float)x0, (float)y0, (float)z).m_7421_(u1, v0).m_5752_();
        } else {
            bufferBuilder.m_252986_(matrices, (float)x0, (float)y1, (float)z).m_7421_(u0, v1).m_5752_();
            bufferBuilder.m_252986_(matrices, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_5752_();
            bufferBuilder.m_252986_(matrices, (float)x1, (float)y0, (float)z).m_7421_(u1, v0).m_5752_();
            bufferBuilder.m_252986_(matrices, (float)x0, (float)y0, (float)z).m_7421_(u0, v0).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }
}

