/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CokeOvenRecipe
extends IESerializableRecipe {
    public static DeferredHolder<RecipeSerializer<?>, IERecipeSerializer<CokeOvenRecipe>> SERIALIZER;
    public static final CachedRecipeList<CokeOvenRecipe> RECIPES;
    public final IngredientWithSize input;
    public final TagOutput output;
    public final int time;
    public final int creosoteOutput;

    public CokeOvenRecipe(TagOutput output, IngredientWithSize input, int time, int creosoteOutput) {
        super(output, IERecipeTypes.COKE_OVEN);
        this.output = output;
        this.input = input;
        this.time = time;
        this.creosoteOutput = creosoteOutput;
    }

    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    protected IERecipeSerializer getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return this.output.get();
    }

    public static CokeOvenRecipe findRecipe(Level level, ItemStack input) {
        return CokeOvenRecipe.findRecipe(level, input, null);
    }

    public static CokeOvenRecipe findRecipe(Level level, ItemStack input, @Nullable CokeOvenRecipe hint) {
        if (input.isEmpty()) {
            return null;
        }
        if (hint != null && hint.matches(input)) {
            return hint;
        }
        for (RecipeHolder<CokeOvenRecipe> recipe : RECIPES.getRecipes(level)) {
            if (!((CokeOvenRecipe)recipe.value()).matches(input)) continue;
            return (CokeOvenRecipe)recipe.value();
        }
        return null;
    }

    static {
        RECIPES = new CachedRecipeList<CokeOvenRecipe>(IERecipeTypes.COKE_OVEN);
    }
}

