/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidTagInput
implements Predicate<FluidStack> {
    public static final MapCodec<FluidTagInput> MAP_CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.mapEither((MapCodec)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("tag"), (MapCodec)ResourceLocation.CODEC.listOf().fieldOf("fluids")).forGetter(t -> t.fluidTag), (App)Codec.INT.fieldOf("amount").forGetter(t -> t.amount), (App)DataComponentPredicate.CODEC.optionalFieldOf("nbt", (Object)DataComponentPredicate.EMPTY).forGetter(t -> t.predicate)).apply((Applicative)inst, FluidTagInput::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidTagInput> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()), FluidTagInput::getMatchingFluidNames, (StreamCodec)ByteBufCodecs.INT, t -> t.amount, (StreamCodec)DataComponentPredicate.STREAM_CODEC, t -> t.predicate, (names, amount, tag) -> new FluidTagInput((Either<TagKey<Fluid>, List<ResourceLocation>>)Either.right((Object)names), (int)amount, (DataComponentPredicate)tag));
    public static final DualMapCodec<RegistryFriendlyByteBuf, FluidTagInput> MAP_CODECS = new DualMapCodec(MAP_CODEC, STREAM_CODEC);
    public static final DualCodec<RegistryFriendlyByteBuf, FluidTagInput> CODECS = MAP_CODECS.codec();
    protected final Either<TagKey<Fluid>, List<ResourceLocation>> fluidTag;
    protected final int amount;
    protected final DataComponentPredicate predicate;

    public FluidTagInput(Either<TagKey<Fluid>, List<ResourceLocation>> matching, int amount, DataComponentPredicate predicate) {
        this.fluidTag = matching;
        this.amount = amount;
        this.predicate = predicate;
    }

    public FluidTagInput(TagKey<Fluid> fluidTag, int amount, @Nonnull DataComponentPredicate predicate) {
        this((Either<TagKey<Fluid>, List<ResourceLocation>>)Either.left(fluidTag), amount, predicate);
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount, @Nonnull DataComponentPredicate predicate) {
        this((TagKey<Fluid>)TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)resourceLocation), amount, predicate);
    }

    public FluidTagInput(ResourceLocation resourceLocation, int amount) {
        this(resourceLocation, amount, DataComponentPredicate.EMPTY);
    }

    public FluidTagInput(TagKey<Fluid> tag, int amount) {
        this(tag, amount, DataComponentPredicate.EMPTY);
    }

    public FluidTagInput withAmount(int amount) {
        return new FluidTagInput(this.fluidTag, amount, this.predicate);
    }

    @Override
    public boolean test(@Nullable FluidStack fluidStack) {
        return this.testIgnoringAmount(fluidStack) && fluidStack.getAmount() >= this.amount;
    }

    public boolean testIgnoringAmount(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        if (!((Boolean)this.fluidTag.map(t -> fluidStack.getFluid().is(t), l -> l.contains(BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid())))).booleanValue()) {
            return false;
        }
        return this.predicate.test((DataComponentHolder)fluidStack);
    }

    @Nonnull
    public List<FluidStack> getMatchingFluidStacks() {
        return ((Stream)this.fluidTag.map(t -> TagUtils.elementStream(BuiltInRegistries.FLUID, t), l -> l.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).get(arg_0)))).map(fluid -> {
            FluidStack matchingStack = new FluidStack(fluid, this.amount);
            matchingStack.applyComponents(this.predicate.asPatch());
            return matchingStack;
        }).collect(Collectors.toList());
    }

    public int getAmount() {
        return this.amount;
    }

    public FluidStack getRandomizedExampleStack(int rand) {
        List<FluidStack> all = this.getMatchingFluidStacks();
        return all.get(rand / 20 % all.size());
    }

    private List<ResourceLocation> getMatchingFluidNames() {
        return (List)this.fluidTag.map(f -> TagUtils.holderStream(BuiltInRegistries.FLUID, f).map(Holder::unwrapKey).map(Optional::orElseThrow).map(ResourceKey::location).collect(Collectors.toList()), l -> l);
    }

    public boolean extractFrom(IFluidHandler handler, IFluidHandler.FluidAction action) {
        for (int tank = 0; tank < handler.getTanks(); ++tank) {
            FluidStack toExtract;
            FluidStack extractedSim;
            FluidStack inTank = handler.getFluidInTank(tank);
            if (!this.testIgnoringAmount(inTank) || (extractedSim = handler.drain(toExtract = inTank.copyWithAmount(this.amount), IFluidHandler.FluidAction.SIMULATE)).getAmount() < this.amount) continue;
            if (action != IFluidHandler.FluidAction.SIMULATE) {
                handler.drain(toExtract, action);
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidTagInput that = (FluidTagInput)o;
        return this.amount == that.amount && Objects.equals(this.fluidTag, that.fluidTag) && Objects.equals(this.predicate, that.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.fluidTag, this.amount, this.predicate);
    }
}

