/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.fx;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.fx.FluidSplashOptions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidSplashParticle
extends TextureSheetParticle {
    public FluidSplashParticle(Fluid fluid, ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
        this.xd *= 0.3;
        this.yd = Math.random() * 0.2 + 0.1;
        this.zd *= 0.3;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.quadSize *= 0.375f;
        this.setFluidTexture(new FluidStack(fluid, 1000));
    }

    public void tick() {
        BlockPos blockpos;
        BlockState iblockstate;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        if (this.lifetime-- <= 0) {
            this.remove();
        }
        if (this.onGround) {
            if (Math.random() < 0.5) {
                this.remove();
            }
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
        if ((iblockstate = this.level.getBlockState(blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z))).liquid() || iblockstate.isSolid()) {
            double d0 = iblockstate.getShape((BlockGetter)this.level, blockpos).max(Direction.Axis.Y);
            double d1 = (double)Mth.floor((double)this.y) + d0;
            if (this.y < d1) {
                this.remove();
            }
        }
    }

    public void setFluidTexture(FluidStack fluid) {
        IClientFluidTypeExtensions fluidProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        this.setSprite(ClientUtils.getSprite(fluidProperties.getStillTexture(fluid)));
        int argb = fluidProperties.getTintColor(fluid);
        this.alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.rCol = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.gCol = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.bCol = (float)(argb & 0xFF) / 255.0f;
    }

    @Nonnull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    public static class Factory
    implements ParticleProvider.Sprite<FluidSplashOptions> {
        @Nullable
        public TextureSheetParticle createParticle(FluidSplashOptions typeIn, @Nonnull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FluidSplashParticle(typeIn.fluid(), worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

