/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.client.gui.elements.ITooltipWidget;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.gui.SorterMenu;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SorterScreen
extends IEContainerScreen<SorterMenu> {
    private static final ResourceLocation TEXTURE = SorterScreen.makeTextureLocation("sorter");

    public SorterScreen(SorterMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.imageHeight = 244;
        this.inventoryLabelY = this.imageHeight - 91;
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        for (int side = 0; side < 6; ++side) {
            int x = this.leftPos + 30 + side / 2 * 58;
            int y = this.topPos + 44 + side % 2 * 76;
            String s = I18n.get((String)("desc.immersiveengineering.info.blockSide." + String.valueOf(Direction.from3DDataValue((int)side))), (Object[])new Object[0]).substring(0, 1);
            RenderSystem.enableBlend();
            graphics.drawString(ClientUtils.font(), s, x - ClientUtils.font().width(s) / 2, y, -1429418804, true);
        }
    }

    @Override
    public void init() {
        super.init();
        this.clearWidgets();
        for (Direction side : Direction.values()) {
            for (FilterBit bit : FilterBit.values()) {
                int sideId = side.ordinal();
                int x = this.leftPos + 3 + sideId / 2 * 58 + bit.ordinal() * 18;
                int y = this.topPos + 3 + sideId % 2 * 76;
                int sideFinal = sideId;
                GetterAndSetter<SorterBlockEntity.FilterConfig> value = ((SorterMenu)this.menu).filterMasks.get(side);
                ButtonSorter b = new ButtonSorter(x, y, bit, value::get, btn -> {
                    CompoundTag tag = new CompoundTag();
                    tag.put("sideConfigVal", SorterBlockEntity.FilterConfig.CODEC.toNBT((Object)bit.toggle((SorterBlockEntity.FilterConfig)value.get())));
                    tag.putInt("sideConfigId", sideFinal);
                    this.sendUpdateToServer(tag);
                    this.fullInit();
                });
                this.addRenderableWidget((GuiEventListener)b);
            }
        }
    }

    public static enum FilterBit {
        TAG,
        NBT,
        DAMAGE;


        public String getTranslationKey() {
            return "desc.immersiveengineering.info.filter." + this.name().toLowerCase(Locale.ROOT);
        }

        public boolean get(SorterBlockEntity.FilterConfig config) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> config.allowTags();
                case 1 -> config.considerComponents();
                case 2 -> config.ignoreDamage();
            };
        }

        public SorterBlockEntity.FilterConfig toggle(SorterBlockEntity.FilterConfig config) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new SorterBlockEntity.FilterConfig(!config.allowTags(), config.considerComponents(), config.ignoreDamage());
                case 1 -> new SorterBlockEntity.FilterConfig(config.allowTags(), !config.considerComponents(), config.ignoreDamage());
                case 2 -> new SorterBlockEntity.FilterConfig(config.allowTags(), config.considerComponents(), !config.ignoreDamage());
            };
        }
    }

    public static class ButtonSorter
    extends GuiButtonBoolean
    implements ITooltipWidget {
        private static final Map<FilterBit, GuiButtonIE.ButtonTexture> TRUE_TEXTURES = Map.of(FilterBit.DAMAGE, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/damage")), FilterBit.NBT, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/components")), FilterBit.TAG, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/tags")));
        private static final Map<FilterBit, GuiButtonIE.ButtonTexture> FALSE_TEXTURES = Map.of(FilterBit.DAMAGE, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/no_damage")), FilterBit.NBT, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/no_components")), FilterBit.TAG, new GuiButtonIE.ButtonTexture(IEApi.ieLoc("sorter/no_tags")));
        private final FilterBit type;
        private final Supplier<SorterBlockEntity.FilterConfig> state;

        public ButtonSorter(int x, int y, FilterBit type, Supplier<SorterBlockEntity.FilterConfig> state, GuiButtonIE.IIEPressable<GuiButtonState<Boolean>> handler) {
            super(x, y, 18, 18, (Component)Component.empty(), () -> type.get((SorterBlockEntity.FilterConfig)state.get()), FALSE_TEXTURES.get((Object)type), TRUE_TEXTURES.get((Object)type), handler);
            this.type = type;
            this.state = state;
        }

        @Override
        public void gatherTooltip(int mouseX, int mouseY, List<Component> tooltip) {
            String[] split = I18n.get((String)this.type.getTranslationKey(), (Object[])new Object[0]).split("<br>");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    tooltip.add((Component)Component.literal((String)split[i]));
                    continue;
                }
                tooltip.add((Component)TextUtils.applyFormat((Component)Component.literal((String)split[i]), ChatFormatting.GRAY));
            }
        }
    }
}

