/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.ConnectorBlockEntityHelper;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ImmersiveConnectableBlockEntity
extends IEBaseBlockEntity
implements IImmersiveConnectable {
    protected GlobalWireNetwork globalNet;
    private final Int2ObjectMap<LocalWireNetwork> cachedLocalNets = new Int2ObjectArrayMap();

    public ImmersiveConnectableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.getBlockPos();
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
    }

    @Override
    public void removeCable(Connection connection, ConnectionPoint attachedPoint) {
        this.setChanged();
    }

    @Override
    public void setLevel(Level worldIn) {
        super.setLevel(worldIn);
        this.globalNet = GlobalWireNetwork.getNetwork(worldIn);
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        return new ConnectionPoint(this.worldPosition, 0);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
    }

    @Override
    public void writeCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        ConnectorBlockEntityHelper.onChunkUnload(this.globalNet, this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        ConnectorBlockEntityHelper.onChunkLoad(this, this.level);
    }

    @Override
    public void setRemovedIE() {
        super.setRemovedIE();
        ConnectorBlockEntityHelper.remove(this.level, this);
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.worldPosition, 0));
    }

    protected LocalWireNetwork getLocalNet(int cpIndex) {
        return ConnectorBlockEntityHelper.getLocalNetWithCache(this.globalNet, this.getBlockPos(), cpIndex, this.cachedLocalNets);
    }

    @Override
    public BlockPos getPosition() {
        return this.worldPosition;
    }
}

