/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ITeslaEntity;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.common.blocks.metal.TeslaCoilBlockEntity;
import blusunrize.immersiveengineering.common.items.FluorescentTubeItem;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class FluorescentTubeEntity
extends Entity
implements ITeslaEntity {
    public static final float TUBE_LENGTH = 1.5f;
    private static final EntityDataAccessor<Boolean> dataMarker_active = SynchedEntityData.defineId(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> dataMarker_r = SynchedEntityData.defineId(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> dataMarker_g = SynchedEntityData.defineId(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> dataMarker_b = SynchedEntityData.defineId(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> dataMarker_angleHorizontal = SynchedEntityData.defineId(FluorescentTubeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int timer = 0;
    public boolean active = false;
    public Color4 rgb = Color4.WHITE;
    boolean firstTick = true;
    public float angleHorizontal = 0.0f;

    public FluorescentTubeEntity(Level world, ItemStack tube, float angleVert) {
        this((EntityType<FluorescentTubeEntity>)((EntityType)IEEntityTypes.FLUORESCENT_TUBE.get()), world);
        this.setYRot(angleVert);
        this.rgb = FluorescentTubeItem.getRGB(tube);
    }

    public FluorescentTubeEntity(EntityType<FluorescentTubeEntity> type, Level world) {
        super(type, world);
    }

    public void tick() {
        super.tick();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        Vec3 motion = this.getDeltaMovement();
        motion = motion.add(0.0, -0.4, 0.0);
        this.move(MoverType.SELF, motion);
        motion = motion.scale(0.98);
        if (this.onGround()) {
            motion = new Vec3(motion.x * 0.7, motion.y * -0.5, motion.z * 0.7);
        }
        if (this.firstTick && !this.level().isClientSide && this.rgb != null) {
            this.entityData.set(dataMarker_r, (Object)Float.valueOf(this.rgb.r()));
            this.entityData.set(dataMarker_g, (Object)Float.valueOf(this.rgb.g()));
            this.entityData.set(dataMarker_b, (Object)Float.valueOf(this.rgb.b()));
            this.entityData.set(dataMarker_angleHorizontal, (Object)Float.valueOf(this.angleHorizontal));
            this.firstTick = false;
        }
        if (this.timer > 0 && !this.level().isClientSide) {
            --this.timer;
            if (this.timer <= 0) {
                this.entityData.set(dataMarker_active, (Object)false);
            }
        }
        if (this.level().isClientSide) {
            this.active = (Boolean)this.entityData.get(dataMarker_active);
            this.rgb = new Color4(((Float)this.entityData.get(dataMarker_r)).floatValue(), ((Float)this.entityData.get(dataMarker_g)).floatValue(), ((Float)this.entityData.get(dataMarker_b)).floatValue(), 1.0f);
            this.angleHorizontal = ((Float)this.entityData.get(dataMarker_angleHorizontal)).floatValue();
        }
        this.setDeltaMovement(motion);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(dataMarker_r, (Object)Float.valueOf(1.0f));
        builder.define(dataMarker_g, (Object)Float.valueOf(1.0f));
        builder.define(dataMarker_b, (Object)Float.valueOf(1.0f));
        builder.define(dataMarker_active, (Object)false);
        builder.define(dataMarker_angleHorizontal, (Object)Float.valueOf(0.0f));
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        CompoundTag comp = nbt.getCompound("nbt");
        this.rgb = Color4.load(comp.get("color"));
        this.angleHorizontal = nbt.getFloat("angleHor");
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        CompoundTag comp = new CompoundTag();
        comp.put("color", this.rgb.save());
        this.angleHorizontal = nbt.getFloat("angleHor");
        nbt.put("nbt", (Tag)comp);
        nbt.putFloat("angleHor", this.angleHorizontal);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isAlive() && !this.level().isClientSide) {
            ItemStack tube = new ItemStack(IEItems.Misc.FLUORESCENT_TUBE);
            FluorescentTubeItem.setRGB(tube, this.rgb);
            ItemEntity ent = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), tube);
            this.level().addFreshEntity((Entity)ent);
            this.discard();
        }
        return super.hurt(source, amount);
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    @Override
    public void onHit(BlockEntity te, boolean lowPower) {
        if (te instanceof TeslaCoilBlockEntity && ((TeslaCoilBlockEntity)te).energyStorage.extractEnergy(1, false) > 0) {
            this.timer = 35;
            this.entityData.set(dataMarker_active, (Object)true);
        }
    }

    @Nonnull
    public InteractionResult interactAt(Player player, Vec3 targetVec3, InteractionHand hand) {
        if (Utils.isHammer(player.getItemInHand(hand))) {
            this.angleHorizontal += (float)(player.isShiftKeyDown() ? 10 : 1);
            this.angleHorizontal %= 360.0f;
            this.entityData.set(dataMarker_angleHorizontal, (Object)Float.valueOf(this.angleHorizontal));
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            if (this.isAlive() && !this.level().isClientSide && player.getItemInHand(hand).isEmpty()) {
                ItemStack tube = new ItemStack(IEItems.Misc.FLUORESCENT_TUBE);
                FluorescentTubeItem.setRGB(tube, this.rgb);
                ItemEntity ent = new ItemEntity(this.level(), player.getX(), player.getY(), player.getZ(), tube, 0.0, 0.0, 0.0);
                this.level().addFreshEntity((Entity)ent);
                this.discard();
            }
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(player, targetVec3, hand);
    }
}

