/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items.bullets;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.entities.WolfpackShotEntity;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Supplier;
import com.mojang.datafixers.util.Unit;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;

public class WolfpackBullet
extends BulletHandler.DamagingBullet<Unit> {
    public WolfpackBullet() {
        super(BulletHandler.CodecsAndDefault.UNIT, (Entity projectile, Entity shooter, Entity hit) -> IEDamageSources.causeWolfpackDamage((RevolvershotEntity)projectile, shooter), () -> ((ModConfigSpec.DoubleValue)IEServerConfig.TOOLS.bulletDamage_Wolfpack).get(), (Supplier<ItemStack>)((Supplier)() -> BulletHandler.emptyShell.asItem().getDefaultInstance()), IEApi.ieLoc("item/bullet_wolfpack"));
    }

    @Override
    public void onHitTarget(Level world, HitResult target, UUID shooterUUID, Entity projectile, boolean headshot, Unit bulletData) {
        super.onHitTarget(world, target, shooterUUID, projectile, headshot, bulletData);
        Vec3 v = projectile.getDeltaMovement().scale(-1.0);
        int split = 6;
        for (int i = 0; i < split; ++i) {
            EntityHitResult eTarget;
            WolfpackShotEntity bullet;
            float angle = (float)i * (360.0f / (float)split);
            Matrix4 matrix = new Matrix4();
            matrix.rotate(angle, v.x, v.y, v.z);
            Vec3 vecDir = new Vec3(0.0, 1.0, 0.0);
            vecDir = matrix.apply(vecDir);
            Entity shooter = null;
            if (shooterUUID != null && world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                shooter = serverLevel.getEntity(shooterUUID);
            }
            if (shooter instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)shooter;
                bullet = new WolfpackShotEntity(world, living, vecDir.x * 1.5, vecDir.y * 1.5, vecDir.z * 1.5, this);
            } else {
                bullet = new WolfpackShotEntity(world, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this);
            }
            if (target instanceof EntityHitResult && (eTarget = (EntityHitResult)target).getEntity() instanceof LivingEntity) {
                bullet.targetOverride = (LivingEntity)eTarget.getEntity();
            }
            bullet.setPos(target.getLocation().x + vecDir.x, target.getLocation().y + vecDir.y, target.getLocation().z + vecDir.z);
            bullet.setDeltaMovement(vecDir.scale(0.375));
            world.addFreshEntity((Entity)bullet);
        }
    }
}

