/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.inventory;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MultiFluidTank
implements IFluidTank,
IFluidHandler {
    public List<FluidStack> fluids = new ArrayList<FluidStack>();
    private final int capacity;

    public MultiFluidTank(int capacity) {
        this.capacity = capacity;
    }

    public MultiFluidTank readFromNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        if (nbt.contains("fluids", 9)) {
            this.fluids.clear();
            ListTag tagList = nbt.getList("fluids", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                FluidStack fs = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tagList.getCompound(i));
                if (fs.isEmpty()) continue;
                this.fluids.add(fs);
            }
        }
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag tagList = new ListTag();
        for (FluidStack fs : this.fluids) {
            if (fs.isEmpty()) continue;
            tagList.add((Object)fs.save(provider));
        }
        nbt.put("fluids", (Tag)tagList);
        return nbt;
    }

    public int getFluidTypes() {
        return this.fluids.size();
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.fluids.size() > 0 ? this.fluids.get(this.fluids.size() - 1) : FluidStack.EMPTY;
    }

    public int getFluidAmount() {
        int sum = 0;
        for (FluidStack fs : this.fluids) {
            sum += fs.getAmount();
        }
        return sum;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isFluidValid(FluidStack stack) {
        return true;
    }

    public int getTanks() {
        return this.fluids.size() + 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < this.fluids.size()) {
            return this.fluids.get(tank);
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        if (tank < this.fluids.size()) {
            return this.fluids.get(tank).getAmount();
        }
        return this.capacity - this.getFluidAmount();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int space = this.capacity - this.getFluidAmount();
        int toFill = Math.min(resource.getAmount(), space);
        if (action.simulate()) {
            return toFill;
        }
        for (FluidStack fs : this.fluids) {
            if (!FluidStack.isSameFluidSameComponents((FluidStack)fs, (FluidStack)resource)) continue;
            fs.grow(toFill);
            return toFill;
        }
        this.fluids.add(0, resource.copyWithAmount(toFill));
        return toFill;
    }

    public int fillRecipe(FluidStack resource, IFluidHandler.FluidAction action) {
        int space = this.capacity - this.getFluidAmount();
        int toFill = Math.min(resource.getAmount(), space);
        if (action.simulate()) {
            return toFill;
        }
        for (FluidStack fs : this.fluids) {
            if (!FluidStack.isSameFluidSameComponents((FluidStack)fs, (FluidStack)resource)) continue;
            fs.grow(toFill);
            return toFill;
        }
        this.fluids.add(resource.copyWithAmount(toFill));
        return toFill;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Iterator<FluidStack> it = this.fluids.iterator();
        while (it.hasNext()) {
            FluidStack fs = it.next();
            if (!FluidStack.isSameFluidSameComponents((FluidStack)fs, (FluidStack)resource)) continue;
            int amount = Math.min(resource.getAmount(), fs.getAmount());
            if (action.execute()) {
                fs.shrink(amount);
                if (fs.getAmount() <= 0) {
                    it.remove();
                }
            }
            return resource.copyWithAmount(amount);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(FluidTagInput fluidTag, IFluidHandler.FluidAction action) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Iterator<FluidStack> it = this.fluids.iterator();
        while (it.hasNext()) {
            FluidStack fs = it.next();
            if (!fluidTag.testIgnoringAmount(fs)) continue;
            int amount = Math.min(fluidTag.getAmount(), fs.getAmount());
            FluidStack ret = fs.copyWithAmount(amount);
            if (action.execute()) {
                fs.shrink(amount);
                if (fs.getAmount() <= 0) {
                    it.remove();
                }
            }
            return ret;
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack drain(int remove, FluidStack removeFrom, Iterator<FluidStack> removeIt, IFluidHandler.FluidAction action) {
        int amount = Math.min(remove, removeFrom.getAmount());
        if (action.execute()) {
            removeFrom.shrink(amount);
            if (removeFrom.isEmpty()) {
                removeIt.remove();
            }
        }
        return removeFrom.copyWithAmount(amount);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return this.drain(this.getFluid().copyWithAmount(maxDrain), doDrain);
    }
}

