/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.ultralib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class UltraConfig<T> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final String configDir;
    public final String[] dirs;
    public final Path configFile;
    public final Class<T> instance;
    public final T instance2;
    private T config;

    public UltraConfig(String modId, String[] dirs, Class<T> instance, T instance2) {
        this.configDir = String.valueOf(FabricLoader.getInstance().getConfigDir()) + File.separator + modId + File.separator;
        this.dirs = dirs;
        this.configFile = Path.of(this.configDir + instance.getName() + ".json", new String[0]);
        this.instance = instance;
        this.instance2 = instance2;
    }

    public T getConfig() {
        return this.config;
    }

    public void init() {
        try {
            for (String dir : this.dirs) {
                Path path = Path.of(this.configDir + dir + File.separator, new String[0]);
                if (Files.exists(path, new LinkOption[0])) continue;
                Files.createDirectory(path, new FileAttribute[0]);
            }
            this.load();
            this.config = this.getConfig();
            this.onInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onInit() {
    }

    public void load() {
        if (!Files.exists(this.configFile, new LinkOption[0])) {
            this.config = this.instance2;
            this.save();
            return;
        }
        try {
            String json = new String(Files.readAllBytes(Paths.get(this.configFile.toUri())));
            Object data = GSON.fromJson(json, this.instance);
            if (data != null) {
                this.config = data;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save() {
        try {
            Files.write(this.configFile, GSON.toJson(this.config).getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

