/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.ultralib.data.loader.list;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.sygii.ultralib.data.loader.resource.ReturnableResource;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.commons.compress.utils.Lists;

public abstract class ListDetachedRunnableDataLoader<T>
extends class_4080<List<T>>
implements IdentifiableResourceReloadListener {
    private final class_2960 loaderId;
    private final String directory;
    private final List<T> loaderList = Lists.newArrayList();

    public ListDetachedRunnableDataLoader(class_2960 loaderId, String directory) {
        this.loaderId = loaderId;
        this.directory = directory;
    }

    public class_2960 getFabricId() {
        return this.loaderId;
    }

    public void runResources(class_3300 manager, class_3695 profiler, ReturnableResource<T> runnable) {
        manager.method_14488(this.directory, id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                JsonObject data = JsonParser.parseReader((Reader)resourceRef.method_43039()).getAsJsonObject();
                String fileName = id.method_12832().replace(this.directory + "/", "").replace(".json", "");
                class_2960 resourceId = class_2960.method_43902((String)id.method_12836(), (String)fileName);
                this.loaderList.add(runnable.run(data, resourceId, fileName));
                resourceRef.method_43039().close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected List<T> prepare(class_3300 manager, class_3695 profiler) {
        this.loaderList.clear();
        this.runResources(manager, profiler, this::reloadResource);
        return this.loaderList;
    }

    protected abstract void apply(List<T> var1, class_3300 var2, class_3695 var3);

    public abstract T reloadResource(JsonObject var1, class_2960 var2, String var3);
}

