/*
 * Decompiled with CFR 0.152.
 */
package dev.sygii.ultralib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.sygii.ultralib.UltraLib;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class UltraConfig<T> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final List<Path> directories = new ArrayList<Path>();
    public final String configDir;
    public final Path configFile;
    public final Class<T> instance;
    public final T instance2;
    public final String modid;
    private T config;

    public UltraConfig(String modId, Class<T> instance, T instance2) {
        this.modid = modId;
        this.configDir = String.valueOf(FabricLoader.getInstance().getConfigDir()) + File.separator + modId + File.separator;
        this.configFile = Path.of(this.configDir + instance.getName() + ".json", new String[0]);
        this.instance = instance;
        this.instance2 = instance2;
        this.directories.add(Path.of(this.configDir, new String[0]));
    }

    public void addDirectory(String dir) {
        this.directories.add(Path.of(this.configDir + dir + File.separator, new String[0]));
    }

    public T getConfig() {
        return this.config;
    }

    public void init() {
        try {
            this.directories.forEach(path -> {
                if (!Files.exists(path, new LinkOption[0])) {
                    try {
                        Files.createDirectory(path, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.load();
            this.config = this.getConfig();
            this.onInit();
        }
        catch (Exception e) {
            UltraLib.LOGGER.error("Initializing config for {}, {}", (Object)this.modid, (Object)e);
        }
    }

    public void onInit() {
    }

    public void load() {
        if (!Files.exists(this.configFile, new LinkOption[0])) {
            this.config = this.instance2;
            return;
        }
        try {
            String json = new String(Files.readAllBytes(Paths.get(this.configFile.toUri())));
            Object data = GSON.fromJson(json, this.instance);
            if (data != null) {
                this.config = data;
            }
            this.save();
        }
        catch (IOException e) {
            UltraLib.LOGGER.error("Loading config for {}, {}", (Object)this.modid, (Object)e);
        }
    }

    public void save() {
        try {
            Files.write(this.configFile, GSON.toJson(this.config).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            UltraLib.LOGGER.error("Saving config for {}, {}", (Object)this.modid, (Object)e);
        }
    }
}

