/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.processcondition;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.tesseract.neoforge.compat.mi.helper.MachineTierHelper;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public record MachineTierProcessCondition(MachineTierReference tier) implements MachineProcessCondition
{
    public static final MapCodec<MachineTierProcessCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MachineTierReference.CODEC.fieldOf("tier").forGetter(MachineTierProcessCondition::tier)).apply((Applicative)instance, MachineTierProcessCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MachineTierProcessCondition> STREAM_CODEC = StreamCodec.composite(MachineTierReference.STREAM_CODEC, MachineTierProcessCondition::tier, MachineTierProcessCondition::new);

    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        return this.tier.tier() == MachineTierHelper.getMachineTier((MachineBlockEntity)context.getBlockEntity());
    }

    public void appendDescription(List<Component> lines) {
        lines.add((Component)MITweaks.text().recipeRequiresMachineTier(this.tier.tier()));
    }

    public ItemStack icon() {
        return this.tier.icon();
    }

    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }

    public static enum MachineTierReference {
        BRONZE(MachineTier.BRONZE, MI.id((String)"bronze_machine_casing")),
        STEEL(MachineTier.STEEL, MI.id((String)"steel_machine_casing")),
        SINGLEBLOCK_ELECTRIC(MachineTier.LV, MI.id((String)"basic_machine_hull")),
        MULTIBLOCK_ELECTRIC(MachineTier.MULTIBLOCK, MI.id((String)"lv_energy_input_hatch"));

        public static final Codec<MachineTierReference> CODEC;
        public static final StreamCodec<ByteBuf, MachineTierReference> STREAM_CODEC;
        private final MachineTier tier;
        private final ResourceLocation iconId;

        private MachineTierReference(MachineTier tier, ResourceLocation iconId) {
            this.tier = tier;
            this.iconId = iconId;
        }

        public MachineTier tier() {
            return this.tier;
        }

        public ItemStack icon() {
            return ((Block)BuiltInRegistries.BLOCK.get(this.iconId)).asItem().getDefaultInstance();
        }

        static {
            CODEC = CodecHelper.forLowercaseEnum(MachineTierReference.class);
            STREAM_CODEC = CodecHelper.forLowercaseEnumStream(MachineTierReference.class);
        }
    }
}

