/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.MachineBlock;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.constantefficiency.hack.MachineEfficiencyHackOption;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.compat.mi.serialization.MICodecs;
import net.swedz.tesseract.neoforge.config.annotation.ConfigComment;
import net.swedz.tesseract.neoforge.config.annotation.ConfigKey;
import net.swedz.tesseract.neoforge.config.annotation.Range;
import net.swedz.tesseract.neoforge.config.annotation.SubSection;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public interface MITweaksConfig {
    @ConfigKey(value="machine_namespace")
    default public String machineNamespace() {
        return "mi_tweaks";
    }

    @ConfigKey(value="tweaks")
    @SubSection
    public Tweaks tweaks();

    @ConfigKey(value="flux_transformer")
    @SubSection
    public FluxTransformer fluxTransformer();

    @ConfigKey(value="eu_transformer")
    @SubSection
    public EUTransformer euTransformer();

    @ConfigKey(value="efficiency")
    @SubSection
    public Efficiency efficiency();

    @ConfigKey(value="machine_blueprints")
    @SubSection
    public MachineBlueprints machineBlueprints();

    public static enum MachineBlueprintRequiredMode {
        DISABLED(null, false),
        INVENTORY(() -> MITweaks.text().blueprintMissingInventory(), false),
        LEARN(() -> MITweaks.text().blueprintMissingLearn(), true),
        INVENTORY_OR_LEARN(() -> MITweaks.text().blueprintMissingInventory(), true);

        private final Supplier<MutableComponent> tooltip;
        private final boolean learning;

        private MachineBlueprintRequiredMode(Supplier<MutableComponent> tooltip, boolean learning) {
            this.tooltip = tooltip;
            this.learning = learning;
        }

        public boolean isDisabled() {
            return this == DISABLED;
        }

        public boolean isEnabled() {
            return !this.isDisabled();
        }

        public boolean isLearning() {
            return this.learning;
        }

        public MutableComponent tooltip() {
            if (this.tooltip == null) {
                throw new UnsupportedOperationException("There is no tooltip for this machine blueprint requirement mode");
            }
            return this.tooltip.get();
        }
    }

    public static final class MachineList {
        public static final Codec<MachineList> CODEC = Codec.list((Codec)Codec.STRING).xmap(MachineList::new, list -> list.config);
        private final List<String> config;
        private final List<ResourceLocation> machineIds;
        private final List<Block> machineBlocks;

        private MachineList(List<String> config) {
            this.config = Collections.unmodifiableList(config);
            this.machineIds = config.stream().flatMap(MachineList::getMatchingMachineBlocks).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0)).toList();
            this.machineBlocks = this.machineIds.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).get(arg_0)).toList();
        }

        public int size() {
            return this.machineIds.size();
        }

        public boolean isEmpty() {
            return this.machineIds.isEmpty();
        }

        public boolean contains(Block machineBlock) {
            return this.machineIds.contains(BuiltInRegistries.BLOCK.getKey((Object)machineBlock));
        }

        public Block get(int index) {
            return (Block)BuiltInRegistries.BLOCK.get(this.machineIds.get(index));
        }

        public Stream<Block> stream() {
            return this.machineBlocks.stream();
        }

        private static Stream<Block> getMatchingMachineBlocks(String regex) {
            Pattern pattern = Pattern.compile(regex);
            return BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof MachineBlock && pattern.matcher(BuiltInRegistries.BLOCK.getKey(block).toString()).matches());
        }
    }

    public static interface MachineBlueprints {
        @ConfigKey(value="learning")
        @ConfigComment(value={"Whether the learning system for blueprints is enabled or not. If true, then blueprints can be right-clicked to become learned"})
        default public boolean learning() {
            return false;
        }

        @ConfigKey(value="machines")
        @ConfigComment(value={"The list of machine ids (accepts regex) that require blueprints to place", "This is only used if any type of machine blueprint requirement is enabled"})
        default public MachineList machines() {
            return new MachineList(List.of());
        }

        @ConfigKey(value="required")
        @ConfigComment(value={"This section's options use the following values:", "DISABLED = Machine blueprints are not required at all", "INVENTORY = The machine blueprint must be in the inventory of the player", "LEARN = Once a machine blueprint is in the inventory of the player, it becomes 'learned' and is not required in the inventory", "INVENTORY_OR_LEARN = The blueprint must be in the inventory of the player or it needs to have been learned"})
        @SubSection
        public Required required();

        public static interface Required {
            @ConfigKey(value="tooltip")
            @ConfigComment(value={"The machine blueprint requirement mode to use for displaying the tooltip warning"})
            default public MachineBlueprintRequiredMode tooltip() {
                return MachineBlueprintRequiredMode.DISABLED;
            }

            @ConfigKey(value="placing")
            @ConfigComment(value={"The machine blueprint requirement mode to use for placing machines"})
            default public MachineBlueprintRequiredMode placing() {
                return MachineBlueprintRequiredMode.DISABLED;
            }

            @ConfigKey(value="rendering_hatches")
            @ConfigComment(value={"The machine blueprint requirement mode to use for rendering hatch positions when holding hatches"})
            default public MachineBlueprintRequiredMode renderingHatches() {
                return MachineBlueprintRequiredMode.DISABLED;
            }
        }
    }

    public static interface Efficiency {
        @ConfigKey(value="hack")
        @ConfigComment(value={"The machine efficiency hack mode to use. Only applies to electric machines", "DISABLED = No change will be made to MI's efficiency behavior", "ALWAYS_BASE = The efficiency will always be the base machine eu (or recipe eu if it's greater) + upgrades", "ALWAYS_MAX = The efficiency will always be forced to max"})
        default public MachineEfficiencyHackOption hack() {
            return MachineEfficiencyHackOption.DISABLED;
        }

        @ConfigKey(value="hide")
        @ConfigComment(value={"Whether efficiency bar and multiblock efficiency data should be hidden or not"})
        default public boolean hide() {
            return false;
        }

        @ConfigKey(value="use_casing_max_overclock_overrides")
        @ConfigComment(value={"Whether the casing max overclock overrides (as per `casing_max_overclock_overrides`) should be used", "This only applies to electric machines. Also applies to multiblocks but uses the highest tier energy hatch's casing", "Note that when this is enabled, it will override any behavior relating to the max efficiency for the `hack` mode (for example, as in `USE_VOLTAGE`)"})
        default public boolean useCasingMaxOverclockOverrides() {
            return false;
        }

        @ConfigKey(value="casing_max_overclock_overrides")
        @ConfigComment(value={"The base max EU/t a machine can run at for a given casing", "Range: > 0"})
        default public CableTierMaxOverclockOverrides casingMaxOverclockOverrides() {
            return new CableTierMaxOverclockOverrides(Map.of(CableTier.LV, 32L, CableTier.MV, 128L, CableTier.HV, 512L, CableTier.EV, 2048L, CableTier.SUPERCONDUCTOR, 8192L));
        }

        public static final class CableTierMaxOverclockOverrides {
            public static final Codec<CableTierMaxOverclockOverrides> CODEC = Codec.unboundedMap((Codec)MICodecs.CABLE_TIER, (Codec)CodecHelper.longRange((long)1L, (long)Long.MAX_VALUE)).xmap(CableTierMaxOverclockOverrides::new, value -> value.overrides);
            private final Map<CableTier, Long> overrides;

            private CableTierMaxOverclockOverrides(Map<CableTier, Long> overrides) {
                this.overrides = overrides;
            }

            public long get(CableTier cableTier) {
                Assert.notNull((Object)cableTier);
                return this.overrides.getOrDefault(cableTier, 32L);
            }
        }
    }

    public static interface EUTransformer {
        @ConfigKey(value="capacity")
        @ConfigComment(value={"The EU capacity of the EU Transformer"})
        @Range.Long(min=1L, max=0x7FFFFFFFFFFFFFFFL)
        default public long capacity() {
            return 200L * CableTier.HV.getEu();
        }

        @ConfigKey(value="max_insert")
        @ConfigComment(value={"The max FE insertable at a time for the EU Transformer"})
        @Range.Long(min=1L, max=0x7FFFFFFFFFFFFFFFL)
        default public long maxInsert() {
            return Long.MAX_VALUE;
        }

        @ConfigKey(value="conversion_rate")
        @ConfigComment(value={"The multiplier to apply on the FE to get EU"})
        @Range.Double(min=0.1, max=1.7976931348623157E308)
        default public double conversionRate() {
            return 1.0;
        }
    }

    public static interface FluxTransformer {
        @ConfigKey(value="capacity")
        @ConfigComment(value={"The EU capacity of the Flux Transformer"})
        @Range.Long(min=1L, max=0x7FFFFFFFFFFFFFFFL)
        default public long capacity() {
            return 200L * CableTier.HV.getEu();
        }

        @ConfigKey(value="max_extract")
        @ConfigComment(value={"The max FE extractable at a time for the Flux Transformer"})
        @Range.Long(min=1L, max=0x7FFFFFFFFFFFFFFFL)
        default public long maxExtract() {
            return Long.MAX_VALUE;
        }

        @ConfigKey(value="conversion_rate")
        @ConfigComment(value={"The multiplier to apply on the EU to get FE"})
        @Range.Double(min=0.1, max=1.7976931348623157E308)
        default public double conversionRate() {
            return 1.0;
        }
    }

    public static interface Tweaks {
        @ConfigKey(value="require_water_biome_for_pump")
        @ConfigComment(value={"Whether water pumps require a water biome (river or ocean) to operate"})
        default public boolean requireWaterBiomeForPump() {
            return false;
        }

        @ConfigKey(value="display_machine_voltage")
        @ConfigComment(value={"Whether the voltage of a machine should be displayed. This includes displaying voltage of hatches and hulls"})
        default public boolean displayMachineVoltage() {
            return false;
        }

        @ConfigKey(value="lock_efficiency_with_redstone")
        @ConfigComment(value={"Whether efficiency should be locked when a redstone module locks a machine, rather than just the crafting operation"})
        default public boolean lockEfficiencyWithRedstone() {
            return false;
        }

        @ConfigKey(value="wrenches_render_multiblock_shapes")
        @ConfigComment(value={"Whether wrenches should render multiblock shapes in world. If false, then only blueprints will be able to render multiblock shapes in world"})
        default public boolean wrenchesRenderMultiblockShapes() {
            return true;
        }

        @ConfigKey(value="display_energy_consumption_on_energy_bar")
        @ConfigComment(value={"Whether the tooltip on the energy bar should display the current energy consumption of the machine"})
        default public boolean displayEnergyConsumptionOnEnergyBar() {
            return false;
        }

        @ConfigKey(value="very_hot_items_burn_time")
        @ConfigComment(value={"The duration in ticks of burn time to apply when holding an item tagged mi_tweaks:very_hot"})
        @Range.Integer(min=1, max=0x7FFFFFFF)
        default public int veryHotItemsBurnTime() {
            return 100;
        }

        @ConfigKey(value="disable_item_fuel_in_multiblock_boilers")
        @ConfigComment(value={"Whether item fuels should be blocked in multiblock boilers"})
        default public boolean disableItemFuelInMultiblockBoilers() {
            return false;
        }
    }
}

