/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.blueprint;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.util.INBTSerializable;

public final class BlueprintsLearned
implements INBTSerializable<ListTag> {
    private Set<ResourceLocation> machinesLearned = Sets.newHashSet();

    private ResourceLocation getId(Block machineBlock) {
        return BuiltInRegistries.BLOCK.getKey((Object)machineBlock);
    }

    public Set<ResourceLocation> get() {
        return Collections.unmodifiableSet(this.machinesLearned);
    }

    public void learn(Block machineBlock) {
        this.machinesLearned.add(this.getId(machineBlock));
    }

    public void unlearn(Block machineBlock) {
        this.machinesLearned.remove(this.getId(machineBlock));
    }

    public boolean hasLearned(Block machineBlock) {
        return this.machinesLearned.contains(this.getId(machineBlock));
    }

    public void mergeFrom(Set<ResourceLocation> machineIds) {
        this.machinesLearned = machineIds;
    }

    public ListTag serializeNBT(HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        for (ResourceLocation machineId : this.machinesLearned) {
            list.add((Object)StringTag.valueOf((String)machineId.toString()));
        }
        return list;
    }

    public void deserializeNBT(HolderLookup.Provider registries, ListTag list) {
        HashSet machinesLearned = Sets.newHashSet();
        for (Tag tag : list) {
            if (!(tag instanceof StringTag)) continue;
            StringTag stringTag = (StringTag)tag;
            machinesLearned.add(ResourceLocation.parse((String)stringTag.getAsString()));
        }
        this.machinesLearned = machinesLearned;
    }
}

