/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.util.TextHelper;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import net.swedz.mi_tweaks.MITweaksAttributes;
import net.swedz.mi_tweaks.MITweaksBlocks;
import net.swedz.mi_tweaks.MITweaksComponents;
import net.swedz.mi_tweaks.MITweaksConfig;
import net.swedz.mi_tweaks.MITweaksDataMaps;
import net.swedz.mi_tweaks.MITweaksItems;
import net.swedz.mi_tweaks.MITweaksOtherRegistries;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.mi_tweaks.compat.mi.custom.MITweaksMIRegistries;
import net.swedz.mi_tweaks.datagen.client.provider.LanguageDatagenProvider;
import net.swedz.mi_tweaks.machine.processcondition.SurroundingArea;
import net.swedz.mi_tweaks.network.MITweaksPackets;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMI;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MIParser;
import net.swedz.tesseract.neoforge.config.ConfigManager;
import net.swedz.tesseract.neoforge.lang.LangInstance;
import net.swedz.tesseract.neoforge.lang.LangManager;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mi_tweaks")
public final class MITweaks {
    public static final String ID = "mi_tweaks";
    public static final String NAME = "MI Tweaks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MI Tweaks");
    private static MITweaksConfig CONFIG;
    private static MITweaksText TEXT;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public MITweaks(IEventBus bus, ModContainer container) {
        MITweaks.setupText();
        MITweaks.setupConfig(bus, container);
        TesseractMI.init((String)ID);
        if (!MITweaks.config().machineNamespace().equals(ID)) {
            TesseractMI.init((String)MITweaks.config().machineNamespace());
        }
        MITweaksAttributes.init(bus);
        MITweaksComponents.init(bus);
        MITweaksItems.init(bus);
        MITweaksBlocks.init(bus);
        MITweaksMIRegistries.init(bus);
        MITweaksOtherRegistries.init(bus);
        bus.addListener(RegisterCapabilitiesEvent.class, event -> CapabilitiesListeners.triggerAll((String)ID, (RegisterCapabilitiesEvent)event));
        bus.addListener(RegisterPayloadHandlersEvent.class, MITweaksPackets::init);
        bus.addListener(RegisterDataMapTypesEvent.class, MITweaksDataMaps::init);
    }

    public static MITweaksConfig config() {
        if (CONFIG == null) {
            ModContainer container = (ModContainer)ModList.get().getModContainerById(ID).orElseThrow();
            MITweaks.setupConfig(container.getEventBus(), container);
        }
        return CONFIG;
    }

    private static void setupConfig(IEventBus bus, ModContainer container) {
        if (CONFIG != null) {
            return;
        }
        ConfigManager manager = new ConfigManager().includeDefaultValueComments();
        manager.codecs().register(MITweaksConfig.Efficiency.CableTierMaxOverclockOverrides.class, MITweaksConfig.Efficiency.CableTierMaxOverclockOverrides.CODEC).register(MITweaksConfig.MachineList.class, MITweaksConfig.MachineList.CODEC);
        CONFIG = (MITweaksConfig)manager.build(MITweaksConfig.class).register(container, ModConfig.Type.STARTUP).load().listenToLoad(bus).config();
    }

    public static MITweaksText text() {
        Assert.notNull((Object)TEXT, (String)"Text not yet loaded");
        return TEXT;
    }

    private static void setupText() {
        LangInstance instance = new LangManager(ID).builtinColorStyles().style("tooltip", () -> MITooltips.DEFAULT_STYLE).style("tooltip_subtext", () -> MITooltips.DEFAULT_STYLE.withItalic(Boolean.valueOf(true))).style("highlighted", () -> MITooltips.HIGHLIGHT_STYLE).builtinParsers().parser(SurroundingArea.class, () -> SurroundingArea::text).parser("percentage", Float.TYPE, () -> value -> Parser.FLOAT_PERCENTAGE.parse(value, (Object)0)).parser("percentage.1", Float.TYPE, () -> value -> Parser.FLOAT_PERCENTAGE.parse(value, (Object)1)).parser("eu_per_tick", Long.TYPE, () -> value -> {
            TextHelper.Amount amount = TextHelper.getAmountGeneric((Number)value);
            return MIText.EuT.text(new Object[]{amount.digit(), amount.unit()});
        }).parser("short", CableTier.class, () -> MIParser.CABLE_TIER_SHORT).parser(ElectricBlastFurnaceBlockEntity.Tier.class, () -> ElectricBlastFurnaceBlockEntity.Tier::getDisplayName).parser(MachineTier.class, () -> tier -> switch (tier) {
            default -> throw new MatchException(null, null);
            case MachineTier.BRONZE -> TEXT.machineTierBronze();
            case MachineTier.STEEL -> TEXT.machineTierSteel();
            case MachineTier.LV -> TEXT.machineTierSingleblockElectric();
            case MachineTier.MULTIBLOCK -> TEXT.machineTierMultiblockElectric();
            case MachineTier.UNLIMITED -> TEXT.machineTierUnlimited();
        }).build(MITweaksText.class).load();
        LanguageDatagenProvider.include(instance);
        TEXT = (MITweaksText)instance.lang();
    }

    public static ResourceLocation machineId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MITweaks.config().machineNamespace(), (String)path);
    }
}

