/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.item;

import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.MITweaksComponents;
import net.swedz.mi_tweaks.MITweaksConfig;
import net.swedz.mi_tweaks.MITweaksItems;
import net.swedz.mi_tweaks.MITweaksOtherRegistries;
import net.swedz.mi_tweaks.blueprint.BlueprintsLearned;
import net.swedz.mi_tweaks.network.packet.UpdateBlueprintsLearnedPacket;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import net.swedz.tesseract.neoforge.proxy.builtin.TesseractProxy;

public final class MachineBlueprintItem
extends Item {
    public MachineBlueprintItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public Component getName(ItemStack stack) {
        if (MachineBlueprintItem.getMachineBlock(stack).isPresent()) {
            return super.getName(stack);
        }
        return Component.translatable((String)(this.getDescriptionId() + ".blank"));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag isAdvanced) {
        TesseractProxy proxy = (TesseractProxy)Proxies.get(TesseractProxy.class);
        if (proxy.isClient()) {
            Player player = proxy.getClientPlayer();
            MachineBlueprintItem.getMachineBlock(stack).ifPresent(machineBlock -> {
                lines.add((Component)MITweaks.text().blueprintMachine((Block)machineBlock));
                if (player != null && MITweaks.config().machineBlueprints().learning() && !MachineBlueprintItem.hasBlueprintLearned(player, machineBlock)) {
                    lines.add((Component)MITweaks.text().blueprintLearn("use"));
                }
            });
        }
    }

    private static Optional<ItemStack> getItemStackMatchingFromInventory(SimpleMember member, Player player) {
        if (player.isCreative()) {
            return Optional.of(member.getPreviewState().getBlock().asItem().getDefaultInstance());
        }
        for (ItemStack item : player.getInventory().items) {
            BlockItem blockItem;
            Item item2 = item.getItem();
            if (!(item2 instanceof BlockItem) || !member.matchesState((blockItem = (BlockItem)item2).getBlock().defaultBlockState())) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        Optional<Block> machineBlockOptional = MachineBlueprintItem.getMachineBlock(stack);
        if (machineBlockOptional.isPresent()) {
            Block machineBlock = machineBlockOptional.get();
            BlueprintsLearned blueprintsLearned = (BlueprintsLearned)player.getData(MITweaksOtherRegistries.BLUEPRINTS_LEARNED);
            if (!blueprintsLearned.hasLearned(machineBlock)) {
                if (!level.isClientSide) {
                    blueprintsLearned.learn(machineBlock);
                    new UpdateBlueprintsLearnedPacket(blueprintsLearned).sendToClient((ServerPlayer)player);
                    player.displayClientMessage((Component)MITweaks.text().blueprintLearned(machineBlock), true);
                    player.swing(usedHand, true);
                }
                return InteractionResultHolder.consume((Object)stack);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand usedHand = context.getHand();
        Level level = context.getLevel();
        Optional<Block> machineBlockOptional = MachineBlueprintItem.getMachineBlock(stack);
        if (machineBlockOptional.isPresent()) {
            MultiblockMachineBlockEntity multiblockMachine;
            BlockEntity blockEntity;
            Block machineBlock = machineBlockOptional.get();
            if (level.getBlockState(context.getClickedPos()).is(machineBlock) && (blockEntity = level.getBlockEntity(context.getClickedPos())) instanceof MultiblockMachineBlockEntity && !(multiblockMachine = (MultiblockMachineBlockEntity)blockEntity).isShapeValid()) {
                ShapeMatcher matcher = new ShapeMatcher(level, multiblockMachine.getBlockPos(), multiblockMachine.getOrientation().facingDirection, multiblockMachine.getActiveShape());
                ArrayList sortedPositions = new ArrayList(matcher.getPositions());
                Collections.sort(sortedPositions);
                for (BlockPos pos : sortedPositions) {
                    Optional<ItemStack> memberStackOptional;
                    SimpleMember member = matcher.getSimpleMember(pos);
                    if (matcher.matches(pos, level, null) || !level.getBlockState(pos).isAir() || !(memberStackOptional = MachineBlueprintItem.getItemStackMatchingFromInventory(member, player)).isPresent()) continue;
                    if (!level.isClientSide) {
                        ItemStack memberStack = memberStackOptional.get();
                        level.setBlock(pos, ((BlockItem)memberStack.getItem()).getBlock().defaultBlockState(), 3);
                        if (!player.getAbilities().instabuild) {
                            memberStack.shrink(1);
                        }
                        player.swing(usedHand, true);
                    }
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static void setMachineBlock(ItemStack stack, Block machineBlock) {
        if (!stack.is(MITweaksItems.MACHINE_BLUEPRINT.asItem())) {
            throw new IllegalArgumentException("Cannot set machine block value of a non-blueprint item");
        }
        if (!(machineBlock instanceof MachineBlock)) {
            throw new IllegalArgumentException("Cannot set machine block value to a non-machine block");
        }
        if (!MITweaks.config().machineBlueprints().machines().contains(machineBlock)) {
            throw new IllegalArgumentException("Cannot set machine block value to a machine block that is not included in the config");
        }
        stack.set(MITweaksComponents.MACHINE_BLOCK, (Object)machineBlock);
    }

    public static Optional<Block> getMachineBlock(ItemStack stack) {
        Block machine;
        if (!stack.is(MITweaksItems.MACHINE_BLUEPRINT.asItem())) {
            throw new IllegalArgumentException("Cannot get machine block value of a non-blueprint item");
        }
        if (stack.has(MITweaksComponents.MACHINE_BLOCK) && (machine = (Block)stack.get(MITweaksComponents.MACHINE_BLOCK)) instanceof MachineBlock) {
            MachineBlock machineBlock = (MachineBlock)machine;
            if (MITweaks.config().machineBlueprints().machines().contains((Block)machineBlock)) {
                return Optional.of(machine);
            }
        }
        return Optional.empty();
    }

    private static boolean hasBlueprintInInventory(Player player, Block machineBlock) {
        Inventory playerInventory = player.getInventory();
        return Stream.concat(playerInventory.items.stream(), playerInventory.offhand.stream()).anyMatch(stack -> {
            if (stack.getItem().equals(MITweaksItems.MACHINE_BLUEPRINT.asItem())) {
                Optional<Block> machineBlockOptional = MachineBlueprintItem.getMachineBlock(stack);
                return machineBlockOptional.isPresent() && machineBlockOptional.get().equals(machineBlock);
            }
            return false;
        });
    }

    private static boolean hasBlueprintLearned(Player player, Block machineBlock) {
        BlueprintsLearned blueprintsLearned = (BlueprintsLearned)player.getData(MITweaksOtherRegistries.BLUEPRINTS_LEARNED);
        return blueprintsLearned.hasLearned(machineBlock);
    }

    public static boolean hasBlueprint(Player player, Block machineBlock, MITweaksConfig.MachineBlueprintRequiredMode requiredMode) {
        return switch (requiredMode) {
            default -> throw new MatchException(null, null);
            case MITweaksConfig.MachineBlueprintRequiredMode.DISABLED -> true;
            case MITweaksConfig.MachineBlueprintRequiredMode.INVENTORY -> MachineBlueprintItem.hasBlueprintInInventory(player, machineBlock);
            case MITweaksConfig.MachineBlueprintRequiredMode.LEARN -> MachineBlueprintItem.hasBlueprintLearned(player, machineBlock);
            case MITweaksConfig.MachineBlueprintRequiredMode.INVENTORY_OR_LEARN -> MachineBlueprintItem.hasBlueprintLearned(player, machineBlock) || MachineBlueprintItem.hasBlueprintInInventory(player, machineBlock);
        };
    }
}

