/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import net.swedz.mi_tweaks.MITweaksAttributes;
import net.swedz.mi_tweaks.MITweaksBlocks;
import net.swedz.mi_tweaks.MITweaksComponents;
import net.swedz.mi_tweaks.MITweaksConfig;
import net.swedz.mi_tweaks.MITweaksDataMaps;
import net.swedz.mi_tweaks.MITweaksItems;
import net.swedz.mi_tweaks.MITweaksOtherRegistries;
import net.swedz.mi_tweaks.compat.mi.custom.MITweaksMIRegistries;
import net.swedz.mi_tweaks.network.MITweaksPackets;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.TesseractMI;
import net.swedz.tesseract.neoforge.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mi_tweaks")
public final class MITweaks {
    public static final String ID = "mi_tweaks";
    public static final String NAME = "MI Tweaks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MI Tweaks");
    private static MITweaksConfig CONFIG;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public MITweaks(IEventBus bus, ModContainer container) {
        MITweaks.setupConfig(bus, container);
        TesseractMI.init((String)ID);
        if (!MITweaks.config().machineNamespace().equals(ID)) {
            TesseractMI.init((String)MITweaks.config().machineNamespace());
        }
        MITweaksAttributes.init(bus);
        MITweaksComponents.init(bus);
        MITweaksItems.init(bus);
        MITweaksBlocks.init(bus);
        MITweaksMIRegistries.init(bus);
        MITweaksOtherRegistries.init(bus);
        bus.addListener(RegisterCapabilitiesEvent.class, event -> CapabilitiesListeners.triggerAll((String)ID, (RegisterCapabilitiesEvent)event));
        bus.addListener(RegisterPayloadHandlersEvent.class, MITweaksPackets::init);
        bus.addListener(RegisterDataMapTypesEvent.class, MITweaksDataMaps::init);
    }

    public static MITweaksConfig config() {
        if (CONFIG == null) {
            ModContainer container = (ModContainer)ModList.get().getModContainerById(ID).orElseThrow();
            MITweaks.setupConfig(container.getEventBus(), container);
        }
        return CONFIG;
    }

    private static void setupConfig(IEventBus bus, ModContainer container) {
        if (CONFIG != null) {
            return;
        }
        ConfigManager manager = new ConfigManager().includeDefaultValueComments();
        manager.codecs().register(MITweaksConfig.Efficiency.CableTierMaxOverclockOverrides.class, MITweaksConfig.Efficiency.CableTierMaxOverclockOverrides.CODEC).register(MITweaksConfig.MachineList.class, MITweaksConfig.MachineList.CODEC);
        CONFIG = (MITweaksConfig)manager.build(MITweaksConfig.class).register(container, ModConfig.Type.STARTUP).load().listenToLoad(bus).config();
    }

    public static ResourceLocation machineId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MITweaks.config().machineNamespace(), (String)path);
    }
}

