/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.CableTierHolder;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.mi_tweaks.item.MachineBlueprintItem;
import net.swedz.tesseract.neoforge.compat.mi.tooltip.MICompatibleTextLine;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import net.swedz.tesseract.neoforge.proxy.builtin.TesseractProxy;
import net.swedz.tesseract.neoforge.tooltip.TooltipAttachment;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public final class MITweaksTooltips {
    public static final TooltipAttachment MACHINE_HULL_AND_ENERGY_HATCH_VOLTAGE = TooltipAttachment.multilinesOptional((flags, context, stack, item) -> {
        MachineBlockEntity patt1$temp;
        MachineBlock machineBlock;
        BlockItem blockItem;
        Block patt0$temp;
        ArrayList lines = Lists.newArrayList();
        CableTier tier = CasingComponent.getCasingTier((Item)item);
        if (tier == null && item instanceof BlockItem && (patt0$temp = (blockItem = (BlockItem)item).getBlock()) instanceof MachineBlock && (machineBlock = (MachineBlock)patt0$temp).getBlockEntityInstance() instanceof HatchBlockEntity && (patt1$temp = machineBlock.getBlockEntityInstance()) instanceof CableTierHolder) {
            CableTierHolder energyHatch = (CableTierHolder)patt1$temp;
            tier = energyHatch.getCableTier();
        }
        if (tier != null) {
            if (MITweaks.config().tweaks().displayMachineVoltage()) {
                lines.add(MICompatibleTextLine.line((TranslatableTextEnum)MITweaksText.MACHINE_VOLTAGE_RECIPES).arg((Object)Component.translatable((String)tier.shortEnglishKey())));
            }
            if (MITweaks.config().efficiency().useCasingMaxOverclockOverrides()) {
                lines.add(MICompatibleTextLine.line((TranslatableTextEnum)MITweaksText.MACHINE_HULL_AND_HATCH_MAX_OVERCLOCK).arg((Object)MITweaks.config().efficiency().casingMaxOverclockOverrides().get(tier), MITooltips.EU_PER_TICK_PARSER));
            }
        }
        return lines.isEmpty() ? Optional.empty() : Optional.of(lines);
    });
    public static final TooltipAttachment MACHINE_BLUEPRINT_MISSING = TooltipAttachment.singleLineOptional((flags, context, stack, item) -> {
        BlockItem blockItem;
        Block patt0$temp;
        Player player;
        TesseractProxy proxy = (TesseractProxy)Proxies.get(TesseractProxy.class);
        if (proxy.isClient() && (player = proxy.getClientPlayer()) != null && MITweaks.config().machineBlueprints().required().tooltip().isEnabled() && item instanceof BlockItem && (patt0$temp = (blockItem = (BlockItem)item).getBlock()) instanceof MachineBlock) {
            MachineBlock machineBlock = (MachineBlock)patt0$temp;
            if (MITweaks.config().machineBlueprints().machines().contains((Block)machineBlock)) {
                return MachineBlueprintItem.hasBlueprint(player, (Block)machineBlock, MITweaks.config().machineBlueprints().required().tooltip()) ? Optional.empty() : Optional.of(MITweaks.config().machineBlueprints().required().tooltip().tooltip().text().withStyle(ChatFormatting.RED));
            }
        }
        return Optional.empty();
    }).noShiftRequired();
    public static final TooltipAttachment FLUX_TRANSFORMER = TooltipAttachment.multilines(List.of(MITweaks.id("flux_transformer")), List.of(MICompatibleTextLine.line((TranslatableTextEnum)MITweaksText.FLUX_TRANSFORMER_HELP).arg((Object)MITweaks.config().fluxTransformer().conversionRate())));
    public static final TooltipAttachment EU_TRANSFORMER = TooltipAttachment.multilines(List.of(MITweaks.id("eu_transformer")), List.of(MICompatibleTextLine.line((TranslatableTextEnum)MITweaksText.EU_TRANSFORMER_HELP).arg((Object)MITweaks.config().euTransformer().conversionRate())));

    public static void init() {
    }
}

