/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.blueprint;

import aztech.modern_industrialization.machines.MachineBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.MITweaksOtherRegistries;
import net.swedz.mi_tweaks.blueprint.BlueprintsLearned;
import net.swedz.mi_tweaks.item.MachineBlueprintItem;
import net.swedz.mi_tweaks.network.packet.UpdateBlueprintsLearnedPacket;

@EventBusSubscriber(modid="mi_tweaks")
public final class MachineBlueprintsListener {
    @SubscribeEvent
    private static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        BlueprintsLearned blueprintsLearned = (BlueprintsLearned)player.getData(MITweaksOtherRegistries.BLUEPRINTS_LEARNED);
        new UpdateBlueprintsLearnedPacket(blueprintsLearned).sendToClient(player);
    }

    @SubscribeEvent
    private static void onUseItemOnBlock(UseItemOnBlockEvent event) {
        BlockItem blockItem;
        Item item;
        Player player = event.getPlayer();
        if (player != null && MITweaks.config().machineBlueprints().required().placing().isEnabled() && event.getUsePhase() == UseItemOnBlockEvent.UsePhase.ITEM_BEFORE_BLOCK && (item = event.getUseOnContext().getItemInHand().getItem()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof MachineBlock) {
            MachineBlock machineBlock = (MachineBlock)item;
            if (MITweaks.config().machineBlueprints().machines().contains((Block)machineBlock) && !MachineBlueprintItem.hasBlueprint(player, (Block)machineBlock, MITweaks.config().machineBlueprints().required().placing())) {
                event.cancelWithResult(ItemInteractionResult.CONSUME);
                player.displayClientMessage((Component)MITweaks.config().machineBlueprints().required().placing().tooltip().text().withStyle(ChatFormatting.RED), true);
            }
        }
    }
}

