/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.MITweaksItems;
import net.swedz.mi_tweaks.item.MachineBlueprintItem;

public final class EmiCopyBlueprintRecipe
extends EmiPatternCraftingRecipe {
    public EmiCopyBlueprintRecipe(ResourceLocation id) {
        super(List.of(EmiStack.of(MITweaksItems.MACHINE_BLUEPRINT), EmiStack.of((ItemLike)Items.PAPER)), EmiStack.of(MITweaksItems.MACHINE_BLUEPRINT), id);
    }

    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new GeneratedSlotWidget(EmiCopyBlueprintRecipe::generateBlueprintItem, this.unique, x, y).catalyst(true);
        }
        if (slot == 1) {
            return new SlotWidget((EmiIngredient)EmiStack.of((ItemLike)Items.PAPER), x, y);
        }
        return new SlotWidget((EmiIngredient)EmiStack.EMPTY, x, y);
    }

    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(EmiCopyBlueprintRecipe::generateBlueprintItem, this.unique, x, y);
    }

    private static EmiStack generateBlueprintItem(Random random) {
        ItemStack blueprintItem = MITweaksItems.MACHINE_BLUEPRINT.asItem().getDefaultInstance();
        if (!MITweaks.config().machineBlueprints().machines().isEmpty()) {
            int index = random.nextInt(MITweaks.config().machineBlueprints().machines().size());
            Block machineBlock = MITweaks.config().machineBlueprints().machines().get(index);
            MachineBlueprintItem.setMachineBlock(blueprintItem, machineBlock);
        }
        return EmiStack.of((ItemStack)blueprintItem);
    }
}

