/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.processcondition;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.mi_tweaks.machine.processcondition.SurroundingArea;
import net.swedz.tesseract.neoforge.api.WorldPos;
import net.swedz.tesseract.neoforge.tooltip.Parser;

public record OpenWaterProcessCondition(SurroundingArea relative, int range, float fill) implements MachineProcessCondition
{
    public static final MapCodec<OpenWaterProcessCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SurroundingArea.CODEC.fieldOf("relative").forGetter(OpenWaterProcessCondition::relative), (App)Codec.intRange((int)1, (int)16).fieldOf("range").forGetter(OpenWaterProcessCondition::range), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("fill", (Object)Float.valueOf(1.0f)).forGetter(OpenWaterProcessCondition::fill)).apply((Applicative)instance, OpenWaterProcessCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenWaterProcessCondition> STREAM_CODEC = StreamCodec.composite(SurroundingArea.STREAM_CODEC, OpenWaterProcessCondition::relative, (StreamCodec)ByteBufCodecs.INT, OpenWaterProcessCondition::range, (StreamCodec)ByteBufCodecs.FLOAT, OpenWaterProcessCondition::fill, OpenWaterProcessCondition::new);
    private static final Cache<WorldPos, Boolean> OPEN_WATER_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        ServerLevel level = context.getLevel();
        WorldPos pos = new WorldPos((Level)level, context.getBlockEntity().getBlockPos());
        Boolean value = (Boolean)OPEN_WATER_CACHE.getIfPresent((Object)pos);
        if (value == null) {
            value = this.calculateOpenWater(pos);
            OPEN_WATER_CACHE.put((Object)pos, (Object)value);
        }
        return value;
    }

    private boolean calculateOpenWater(WorldPos pos) {
        WaterCountResult result = this.countWater(pos);
        int areaNeeded = Math.round((float)result.total() * this.fill);
        return result.water() >= (long)areaNeeded;
    }

    private WaterCountResult countWater(WorldPos origin) {
        ArrayList blocks = StreamSupport.stream(this.relative.blocks(origin.pos(), this.range).spliterator(), false).map(BlockPos::immutable).filter(pos -> !pos.equals((Object)origin.pos())).collect(Collectors.toCollection(Lists::newArrayList));
        long total = blocks.size();
        long water = blocks.stream().map(pos -> new WorldPos((Level)origin.level(), pos)).filter(this::isWater).count();
        return new WaterCountResult(total, water);
    }

    private boolean isWater(WorldPos pos) {
        return pos.level().getBlockState(pos.pos()).getFluidState().is(FluidTags.WATER);
    }

    public void appendDescription(List<Component> list) {
        list.add((Component)MITweaksText.RECIPE_REQUIRES_OPEN_WATER.text(new Object[]{Parser.FLOAT_PERCENTAGE.parse((Object)Float.valueOf(this.fill), (Object)1), this.relative.text(), this.range}));
    }

    public ItemStack icon() {
        return Items.WATER_BUCKET.getDefaultInstance();
    }

    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }

    private record WaterCountResult(long total, long water) {
    }
}

