/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machine.processcondition;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.AABB;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.tesseract.neoforge.helper.CodecHelper;
import net.swedz.tesseract.neoforge.tooltip.TranslatableTextEnum;

public enum SurroundingArea {
    ALL(MITweaksText.RECIPE_REQUIRES_SURROUNDING_AREA_ALL, (origin, range) -> origin.offset(-range.intValue(), -range.intValue(), -range.intValue()), (origin, range) -> origin.offset(range.intValue(), range.intValue(), range.intValue())),
    AT_AND_BELOW(MITweaksText.RECIPE_REQUIRES_SURROUNDING_AREA_AT_AND_BELOW, (origin, range) -> origin.offset(-range.intValue(), -range.intValue(), -range.intValue()), (origin, range) -> origin.offset(range.intValue(), 0, range.intValue())),
    BELOW(MITweaksText.RECIPE_REQUIRES_SURROUNDING_AREA_BELOW, (origin, range) -> origin.offset(-range.intValue(), -range.intValue(), -range.intValue()), (origin, range) -> origin.offset(range.intValue(), -1, range.intValue())),
    AT_AND_ABOVE(MITweaksText.RECIPE_REQUIRES_SURROUNDING_AREA_AT_AND_ABOVE, (origin, range) -> origin.offset(-range.intValue(), 0, -range.intValue()), (origin, range) -> origin.offset(range.intValue(), range.intValue(), range.intValue())),
    ABOVE(MITweaksText.RECIPE_REQUIRES_SURROUNDING_AREA_ABOVE, (origin, range) -> origin.offset(-range.intValue(), 1, -range.intValue()), (origin, range) -> origin.offset(range.intValue(), range.intValue(), range.intValue()));

    public static final Codec<SurroundingArea> CODEC;
    public static final StreamCodec<ByteBuf, SurroundingArea> STREAM_CODEC;
    private final TranslatableTextEnum text;
    private final BiFunction<BlockPos, Integer, BlockPos> firstPos;
    private final BiFunction<BlockPos, Integer, BlockPos> secondPos;

    private SurroundingArea(TranslatableTextEnum text, BiFunction<BlockPos, Integer, BlockPos> firstPos, BiFunction<BlockPos, Integer, BlockPos> secondPos) {
        this.text = text;
        this.firstPos = firstPos;
        this.secondPos = secondPos;
    }

    public MutableComponent text() {
        return this.text.text();
    }

    public Iterable<BlockPos> blocks(BlockPos origin, int range) {
        return BlockPos.betweenClosed((BlockPos)this.firstPos.apply(origin, range), (BlockPos)this.secondPos.apply(origin, range));
    }

    public AABB bounds(BlockPos origin, int range) {
        return AABB.encapsulatingFullBlocks((BlockPos)this.firstPos.apply(origin, range), (BlockPos)this.secondPos.apply(origin, range));
    }

    static {
        CODEC = CodecHelper.forLowercaseEnum(SurroundingArea.class);
        STREAM_CODEC = CodecHelper.forLowercaseEnumStream(SurroundingArea.class);
    }
}

