/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kirdow.itemlocks.ItemLocks;
import com.kirdow.itemlocks.Logger;
import com.kirdow.itemlocks.config.ILConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(ItemLocks.modFolder, "ktnilcks.json");
    private static ILConfig config;

    public static ILConfig get() {
        return config;
    }

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (ILConfig)GSON.fromJson((Reader)reader, ILConfig.class);
            }
            catch (IOException ex) {
                Logger.exception(ex);
            }
        } else {
            config = new ILConfig();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException ex) {
            Logger.exception(ex);
        }
    }
}

