/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.data;

import com.kirdow.itemlocks.Logger;
import com.kirdow.itemlocks.client.data.LockRepository;
import com.kirdow.itemlocks.client.update.UpdateManager;
import com.kirdow.itemlocks.common.Reference;
import com.kirdow.itemlocks.proxy.Components;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.Utils;

public class LockService {
    private LockRepository lockRepository;
    private int loadState = 0;

    private boolean loadState() {
        boolean result = this.loadState == 0;
        ++this.loadState;
        return result;
    }

    private boolean unloadState() {
        boolean result = this.loadState == 1;
        --this.loadState;
        return result;
    }

    public void onWorldLoad() {
        Core.mc().method_63588(this::loadRepository);
        Utils.after(5000L, UpdateManager.UPDATE_MANAGER::checkAndNotifyAsync);
    }

    public void onWorldUnload() {
        this.unloadRepository();
    }

    private void unloadRepository() {
        if (this.lockRepository == null || this.lockRepository.isNull()) {
            return;
        }
        if (this.lockRepository.save()) {
            Logger.info("Saved lock repository '%s'", this.lockRepository.getRaw());
        } else {
            Logger.error("Failed to save lock repository '%s'", this.lockRepository.getRaw());
        }
    }

    private void loadRepository() {
        this.unloadRepository();
        this.lockRepository = Reference.lockRepository().findRepository();
        if (this.lockRepository.isNull()) {
            Logger.error("Lock repository loaded is null...", new Object[0]);
        } else {
            Logger.info("Loaded lock repository '%s'", this.lockRepository.getRaw());
        }
    }

    public static LockRepository getLockRepository() {
        LockService service = LockService.getService();
        if (service == null) {
            Logger.debug("No LockService present", new Object[0]);
            return LockRepository.NULL;
        }
        LockRepository repo = service.lockRepository;
        if (repo == null) {
            Logger.debug("No LockRepository present in LockService", new Object[0]);
            return LockRepository.NULL;
        }
        if (repo.isNull()) {
            Logger.debug("LockRepository present in LockService is invalid", new Object[0]);
            return LockRepository.NULL;
        }
        return repo;
    }

    public static LockService getService() {
        return Components.getComponent(LockService.class);
    }
}

