/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class Logger {
    private static Consumer<String> loggerInfo;
    private static Consumer<String> loggerDebug;
    private static Consumer<String> loggerError;
    private static Consumer<String> loggerWarn;
    private static Consumer<Exception> loggerEx;
    private static final int THROTTLE_LIMIT_AGE = 350;
    private static final Set<ThrottledMessage<?>> throttleSet;

    public static void setLogger(Consumer<String> info, Consumer<String> debug, Consumer<String> error, Consumer<String> warn, Consumer<Exception> ex) {
        loggerInfo = info;
        loggerDebug = debug;
        loggerError = error;
        loggerWarn = warn;
        loggerEx = ex;
    }

    private static void refreshThrottleCache() {
        throttleSet.removeIf(p -> !p.validAge());
    }

    private static <T> boolean throttle(T message) {
        Logger.refreshThrottleCache();
        ThrottledMessage<T> msg = new ThrottledMessage<T>(message);
        if (throttleSet.contains(msg)) {
            return true;
        }
        throttleSet.add(msg);
        return false;
    }

    public static void info(String format, Object ... args) {
        Logger.log(String.format(format, args), loggerInfo);
    }

    public static void debug(String format, Object ... args) {
        Logger.log(String.format(format, args), loggerDebug);
    }

    public static void error(String format, Object ... args) {
        Logger.log(String.format(format, args), loggerError);
    }

    public static void warn(String format, Object ... args) {
        Logger.log(String.format(format, args), loggerWarn);
    }

    public static void exception(Exception ex) {
        Logger.log(ex, loggerEx);
    }

    private static <T> void log(T msg, Consumer<T> func) {
        if (Logger.throttle(msg)) {
            return;
        }
        func.accept(msg);
    }

    static {
        throttleSet = new HashSet();
    }

    private static class ThrottledMessage<T> {
        public final int hashCode;
        public final long time;

        public ThrottledMessage(T message) {
            this.hashCode = message.hashCode();
            this.time = System.currentTimeMillis();
        }

        public int hashCode() {
            return 527 + this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ThrottledMessage)) {
                return false;
            }
            ThrottledMessage other = (ThrottledMessage)obj;
            return other.hashCode == this.hashCode;
        }

        public boolean validAge() {
            return System.currentTimeMillis() < this.time + 350L;
        }
    }
}

