/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.render;

import com.kirdow.itemlocks.ItemLocks;
import com.kirdow.itemlocks.client.LockManager;
import com.kirdow.itemlocks.client.input.KeyBindings;
import com.kirdow.itemlocks.client.render.ELockModifier;
import com.kirdow.itemlocks.client.render.Res;
import com.kirdow.itemlocks.config.ConfigManager;
import com.kirdow.itemlocks.mixin.AbstractContainerScreenAccessor;
import com.kirdow.itemlocks.mixin.SlotAccessor;
import com.kirdow.itemlocks.proxy.Components;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.enums.ContainerType;
import com.kirdow.itemlocks.util.reflect.ReflectUtil;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class RenderContainer {
    private static LockManager manager = null;
    public static final String ILTTP = "\u00a76ItemLocks\u00a78: \u00a7a";
    private static final PoseStack ms = new PoseStack();

    private static LockManager getManager() {
        if (manager != null) {
            return manager;
        }
        manager = Components.getComponent(LockManager.class);
        return manager;
    }

    public static void drawScreen(AbstractContainerScreen screen, GuiGraphics ctx) {
        int y;
        int x;
        LockManager manager = RenderContainer.getManager();
        Slot hoveredSlot = ((AbstractContainerScreenAccessor)screen).getHoveredSlot();
        boolean mode = KeyBindings.isToggle();
        GlStateManager._enableBlend();
        GlStateManager._clear((int)256);
        NonNullList slots = screen.getMenu().slots;
        ContainerType containerType = ContainerType.match(screen);
        Inventory playerInventory = Core.mc().player.getInventory();
        boolean bypass = KeyBindings.isBypass() || ConfigManager.get().bypassAll || !screen.getMenu().getCarried().isEmpty() && ConfigManager.get().bypassHeld;
        boolean unlockedSlots = false;
        for (Slot slot : slots) {
            if (slot.container != playerInventory || !manager.isLockedSlot(containerType, ((SlotAccessor)slot).getSlotIndex())) continue;
            boolean unlock = mode && hoveredSlot == slot;
            x = slot.x;
            y = slot.y;
            if (bypass && hoveredSlot == slot) {
                RenderContainer.drawLock(ctx, x, y, unlock ? ELockModifier.LiftedUnlocked : ELockModifier.Unlocked);
                continue;
            }
            if (slot.hasItem()) {
                RenderContainer.drawLock(ctx, x, y, unlock ? ELockModifier.LiftedLocked : ELockModifier.Locked);
                continue;
            }
            RenderContainer.drawLock(ctx, x, y, unlock ? ELockModifier.LiftedUnlocked : ELockModifier.Unlocked);
            unlockedSlots = true;
        }
        if (unlockedSlots && ItemLocks.hasTips()) {
            x = 8;
            y = 8 + ReflectUtil.getYSize(screen);
            String[] strs = !Core.player().getInventory().getSelectedItem().isEmpty() ? new String[]{"\u00a76ItemLocks\u00a78: \u00a7aEmpty slots with a lock are", "shown unlocked, allowing to place", "held items in those slots!"} : new String[]{"\u00a76ItemLocks\u00a78: \u00a7aUnlock empty slots by holding", "lock key and pressing LMB"};
            for (String str : strs) {
                Font font = Core.mc().font;
                ctx.drawString(font, (Component)Component.literal((String)str), x, y, ChatFormatting.GREEN.getColor().intValue(), true);
                Objects.requireNonNull(Core.mc().font);
                y += 9 + 2;
            }
        }
    }

    public static void drawHotbar(GuiGraphics ctx, LockManager manager) {
        if (!ConfigManager.get().hotbarVisible) {
            return;
        }
        int width = Core.mc().getWindow().getGuiScaledWidth();
        int height = Core.mc().getWindow().getGuiScaledHeight();
        int x = width / 2 - 87;
        int y = height - 18;
        GlStateManager._disableDepthTest();
        for (int i = 0; i < 9; ++i) {
            if (!manager.isLockedSlot(ContainerType.HOTBAR, i)) continue;
            if (!Core.player().getInventory().getItem(i).isEmpty()) {
                RenderContainer.drawLock(ctx, x + i * 20, y, KeyBindings.isBypass() ? ELockModifier.LiftedLocked : ELockModifier.Locked);
                continue;
            }
            RenderContainer.drawLock(ctx, x + i * 20, y, ELockModifier.Unlocked);
        }
        GlStateManager._enableDepthTest();
    }

    public static void drawLock(GuiGraphics ctx, int x, int y, ELockModifier modifier) {
        int posX = x + 12;
        int posY = y - 4;
        switch (modifier) {
            case Locked: {
                ctx.blit(RenderPipelines.GUI_TEXTURED, Res.TEXTURE_ICONS, posX, posY, 0.0f, 16.0f, 6, 11, 6, 11, 256, 256);
                break;
            }
            case Unlocked: {
                ctx.blit(RenderPipelines.GUI_TEXTURED, Res.TEXTURE_ICONS, posX, posY, 16.0f, 16.0f, 10, 11, 10, 11, 256, 256);
                break;
            }
            case LiftedLocked: {
                ctx.blit(RenderPipelines.GUI_TEXTURED, Res.TEXTURE_ICONS, posX, posY - 1, 0.0f, 16.0f, 6, 5, 6, 5, 256, 256);
                ctx.blit(RenderPipelines.GUI_TEXTURED, Res.TEXTURE_ICONS, posX, posY + 5, 0.0f, 21.0f, 6, 6, 6, 6, 256, 256);
                break;
            }
            case LiftedUnlocked: {
                ctx.blit(RenderPipelines.GUI_TEXTURED, Res.TEXTURE_ICONS, posX, posY - 1, 16.0f, 16.0f, 10, 5, 10, 6, 256, 256);
                ctx.blit(RenderPipelines.GUI_TEXTURED, Res.TEXTURE_ICONS, posX, posY + 5, 16.0f, 21.0f, 6, 6, 6, 6, 256, 256);
            }
        }
    }
}

