/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.forge;

import com.kirdow.itemlocks.ItemLocks;
import com.kirdow.itemlocks.Logger;
import com.kirdow.itemlocks.client.LockManager;
import com.kirdow.itemlocks.client.data.LockService;
import com.kirdow.itemlocks.client.input.KeyBindings;
import com.kirdow.itemlocks.client.render.RenderContainer;
import com.kirdow.itemlocks.client.update.UpdateManager;
import com.kirdow.itemlocks.common.KeyboardEvent;
import com.kirdow.itemlocks.common.MouseEvent;
import com.kirdow.itemlocks.common.Reference;
import com.kirdow.itemlocks.config.ConfigManager;
import com.kirdow.itemlocks.config.ILConfigScreen;
import com.kirdow.itemlocks.forge.ClientHelper;
import com.kirdow.itemlocks.forge.LockRepositoryForge;
import com.kirdow.itemlocks.forge.ModEvents;
import com.kirdow.itemlocks.forge.ReferenceForge;
import com.kirdow.itemlocks.mixin.AbstractContainerScreenAccessor;
import com.kirdow.itemlocks.mixin.KeyMappingAccessor;
import com.kirdow.itemlocks.mixin.SlotAccessor;
import com.kirdow.itemlocks.proxy.Components;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.enums.ContainerType;
import com.kirdow.itemlocks.util.locks.InventoryHelper;
import com.kirdow.itemlocks.util.reflect.ReflectClass;
import java.io.File;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

@Mod(value="ktnilcks")
public class ItemLocksForge {
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger((String)String.format("%s", "ktnilcks"));

    public ItemLocksForge(IEventBus eventBus, ModContainer container) {
        Logger.setLogger(arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).info(arg_0), arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).debug(arg_0), arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).error(arg_0), arg_0 -> ((org.apache.logging.log4j.Logger)LOGGER).warn(arg_0), ex -> LOGGER.catching(Level.ERROR, (Throwable)ex));
        if (FMLEnvironment.getDist() != Dist.CLIENT) {
            Logger.info("Disabled because not running on the client.", new Object[0]);
            return;
        }
        ReflectClass.forClass(Reference.class).getDeclaredFieldByName("_i").set(null, new ReferenceForge());
        ReflectClass.forClass(Reference.class).getDeclaredFieldByName("_lockRepository").set(null, new LockRepositoryForge());
        Logger.info("Preparing mod config directory", new Object[0]);
        ItemLocks.modFolder = new File(FMLPaths.CONFIGDIR.get().toFile(), "ItemLocks");
        if (!ItemLocks.modFolder.exists()) {
            Logger.info("Creating config directory", new Object[0]);
            if (!ItemLocks.modFolder.mkdir()) {
                Logger.error("Failed creating config directory: %s", ItemLocks.modFolder.getAbsolutePath());
            }
        }
        ConfigManager.loadConfig();
        ReflectClass.forClass(Components.class).getDeclaredMethodByName("registerComponents", new Class[0]).invoke(null, new Object[0]);
        NeoForge.EVENT_BUS.register((Object)this);
        eventBus.register(ModEvents.class);
        KeyBindings.init();
        container.registerExtensionPoint(IConfigScreenFactory.class, ClientHelper::createConfigGuiFactory);
    }

    private LockManager getLockManager() {
        return Components.getComponent(LockManager.class);
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        UpdateManager.queryOutdated();
    }

    @SubscribeEvent
    public void onKeyPress(InputEvent.Key event) {
        if (event.getAction() != 1) {
            return;
        }
        if (KeyBindings.keyShowOptions.matches(event.getKeyEvent()) && !Core.isScreen()) {
            ILConfigScreen.showConfig(Core.mc().screen, true);
        }
    }

    @SubscribeEvent
    public void onPlayerConnect(ClientPlayerNetworkEvent.LoggingIn event) {
        UpdateManager.UPDATE_MANAGER.checkAndNotifyAsync();
    }

    @SubscribeEvent
    public void onContainerForeground(ContainerScreenEvent.Render.Foreground event) {
        AbstractContainerScreen container = event.getContainerScreen();
        if (container == null) {
            return;
        }
        RenderContainer.drawScreen(container, event.getGuiGraphics());
    }

    @SubscribeEvent
    public void onMousePress(ScreenEvent.MouseButtonPressed.Pre event) {
        if (this.onScreenMouseEvent((ScreenEvent)event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onMouseRelease(ScreenEvent.MouseButtonReleased.Pre event) {
        if (this.onScreenMouseEvent((ScreenEvent)event)) {
            event.setCanceled(true);
        }
    }

    public boolean onScreenMouseEvent(ScreenEvent event) {
        if (!(event instanceof ScreenEvent.MouseButtonPressed.Pre) && !(event instanceof ScreenEvent.MouseButtonReleased.Pre)) {
            return false;
        }
        int button = event instanceof ScreenEvent.MouseButtonPressed ? ((ScreenEvent.MouseButtonPressed)event).getButton() : ((ScreenEvent.MouseButtonReleased)event).getButton();
        boolean press = event instanceof ScreenEvent.MouseButtonPressed;
        MouseEvent mouseEvent = new MouseEvent(press ? MouseEvent.EMouseAction.Click : MouseEvent.EMouseAction.Release, MouseEvent.EMouseButton.of(button));
        return this.getLockManager().mouseEvent(mouseEvent);
    }

    @SubscribeEvent
    public void onScreenKeyboardEvent(ScreenEvent.KeyPressed.Pre event) {
        KeyboardEvent keyboardEvent = new KeyboardEvent(event.getKeyEvent(), true);
        if (this.getLockManager().keyboardEvent(keyboardEvent)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (!ItemLocks.hasTips()) {
            return;
        }
        Player player = event.getEntity();
        if (player != Core.player() || !Core.isPlayer()) {
            return;
        }
        if (!Core.isScreen(AbstractContainerScreen.class)) {
            return;
        }
        AbstractContainerScreen gui = (AbstractContainerScreen)Core.screen();
        ContainerType type = ContainerType.match(gui);
        Slot slot = ((AbstractContainerScreenAccessor)gui).getHoveredSlot();
        if (slot == null || slot.container != Core.player().getInventory()) {
            return;
        }
        if (slot.getItem() != event.getItemStack()) {
            return;
        }
        boolean empty = !slot.hasItem();
        boolean toggleKey = KeyBindings.isToggle();
        int slotIndex = ((SlotAccessor)slot).getSlotIndex();
        boolean shouldBypass = KeyBindings.isBypass() || empty;
        LockManager manager = Components.getComponent(LockManager.class);
        String lockStr = ((KeyMappingAccessor)KeyBindings.keyLockHold).getKey().getDisplayName().getString().toUpperCase();
        String bypassStr = ((KeyMappingAccessor)KeyBindings.keyLockBypassHold).getKey().getDisplayName().getString().toUpperCase();
        List tooltip = event.getToolTip();
        if (!toggleKey) {
            boolean locked;
            boolean bl = locked = !shouldBypass && manager.isLockedSlot(type, slotIndex);
            if (shouldBypass) {
                tooltip.add(Component.literal((String)"\u00a76ItemLocks\u00a78: \u00a7aBypass active!"));
            } else if (locked) {
                tooltip.add(Component.literal((String)("\u00a76ItemLocks\u00a78: \u00a7aUnlock: Hold " + lockStr + " + Press LMB!")));
                tooltip.add(Component.literal((String)("\u00a76ItemLocks\u00a78: \u00a7aBypass: Hold " + bypassStr + "!")));
            } else {
                tooltip.add(Component.literal((String)("\u00a76ItemLocks\u00a78: \u00a7aLock: Hold " + lockStr + " + Press LMB!")));
                tooltip.add(Component.literal((String)("\u00a76ItemLocks\u00a78: \u00a7aBypass: Hold " + bypassStr + "!")));
            }
        } else {
            int slotRaw = InventoryHelper.getSlotFromIncrement(type, slotIndex);
            boolean isLocked = manager.isLockedSlotRaw(slotRaw);
            if (isLocked) {
                tooltip.add(Component.literal((String)"\u00a76ItemLocks\u00a78: \u00a7aUnlock: Press LMB"));
            } else {
                tooltip.add(Component.literal((String)"\u00a76ItemLocks\u00a78: \u00a7aLock: Press LMB"));
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        LockService.getService().onWorldLoad();
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        LockService.getService().onWorldUnload();
    }

    @SubscribeEvent
    public void onNetworkEstablished(ClientPlayerNetworkEvent.LoggingIn event) {
        Components.getComponent(LockManager.class).onNetworkEstablished(event.getConnection());
    }
}

