/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client;

import com.kirdow.itemlocks.client.data.LockRepository;
import com.kirdow.itemlocks.client.data.LockService;
import com.kirdow.itemlocks.client.input.KeyBindings;
import com.kirdow.itemlocks.common.KeyboardEvent;
import com.kirdow.itemlocks.common.MouseEvent;
import com.kirdow.itemlocks.config.ConfigManager;
import com.kirdow.itemlocks.mixin.AbstractContainerScreenAccessor;
import com.kirdow.itemlocks.mixin.ConnectionAccessor;
import com.kirdow.itemlocks.mixin.SlotAccessor;
import com.kirdow.itemlocks.proxy.Components;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.enums.ContainerType;
import com.kirdow.itemlocks.util.locks.InventoryHelper;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.inventory.Slot;

public class LockManager {
    public boolean mouseEvent(MouseEvent event) {
        boolean shouldBypass;
        if (!(Core.isPlayer() && Core.isWorld() && Core.isScreen(AbstractContainerScreen.class))) {
            return false;
        }
        boolean isToggleEvent = event.action.isPress;
        MouseEvent.EMouseButton button = event.button;
        if (button == null) {
            return false;
        }
        AbstractContainerScreen gui = (AbstractContainerScreen)Core.screen();
        ContainerType type = ContainerType.match(gui);
        Slot slot = ((AbstractContainerScreenAccessor)gui).getHoveredSlot();
        if (slot == null || slot.container != Core.player().getInventory()) {
            return false;
        }
        if (!gui.getMenu().getCarried().isEmpty()) {
            isToggleEvent = !isToggleEvent;
        }
        boolean empty = !slot.hasItem();
        boolean toggleKey = KeyBindings.isToggle();
        int slotIndex = ((SlotAccessor)slot).getSlotIndex();
        boolean bl = shouldBypass = KeyBindings.isBypass() || empty || ConfigManager.get().bypassHeld && event.action.isRelease || ConfigManager.get().bypassAll;
        if (!toggleKey) {
            boolean locked = !shouldBypass && this.isLockedSlot(type, slotIndex);
            return locked && !button.isMiddle;
        }
        if (!isToggleEvent) {
            return false;
        }
        int slotRaw = InventoryHelper.getSlotFromIncrement(type, slotIndex);
        boolean isLocked = this.isLockedSlotRaw(slotRaw);
        if (isLocked || !empty) {
            this.setLockedSlotRaw(!isLocked, slotRaw);
        }
        return true;
    }

    public boolean keyboardEvent(KeyboardEvent event) {
        if (!(Core.isPlayer() && Core.isWorld() && Core.isScreen(AbstractContainerScreen.class))) {
            return false;
        }
        if (!this.isVanillaDropActive(event) && !this.isVanillaSwapActive(event)) {
            return false;
        }
        AbstractContainerScreen gui = (AbstractContainerScreen)Core.screen();
        Slot slot = ((AbstractContainerScreenAccessor)gui).getHoveredSlot();
        if (slot == null || slot.container != Core.player().getInventory()) {
            return false;
        }
        return this.isLockedSlot(ContainerType.match(gui), ((SlotAccessor)slot).getSlotIndex()) && !KeyBindings.isBypass();
    }

    public void setLockedSlots(ContainerType type, boolean state, int ... slots) {
        for (int slot : slots) {
            this.setLockedSlot(type, state, slot);
        }
    }

    public void setLockedSlot(ContainerType type, boolean state, int slot) {
        int slotRaw = InventoryHelper.getSlotFromIncrement(type, slot);
        this.setLockedSlotRaw(state, slotRaw);
    }

    public void setLockedSlotsRaw(boolean state, int ... slots) {
        for (int slot : slots) {
            this.setLockedSlotRaw(state, slot);
        }
    }

    public void setLockedSlotRaw(boolean state, int slot) {
        LockRepository repo = LockService.getLockRepository();
        if (state) {
            repo.lock(slot);
        } else {
            repo.unlock(slot);
        }
        repo.saveAsync();
    }

    public boolean isLockedSlot(ContainerType type, int slot) {
        int slotRaw = InventoryHelper.getSlotFromIncrement(type, slot);
        return this.isLockedSlotRaw(slotRaw);
    }

    public boolean isLockedSlotRaw(int slotRaw) {
        LockRepository repo = LockService.getLockRepository();
        return repo.isLocked(slotRaw);
    }

    public void onNetworkEstablished(Connection connection) {
        ChannelPipeline pipeline = ((ConnectionAccessor)connection).getChannel().pipeline();
        pipeline.addLast(new ChannelHandler[]{new DropFetcher()});
    }

    private boolean isVanillaDropActive(KeyboardEvent event) {
        return Core.mc().options.keyDrop.matches(event.key);
    }

    private boolean isVanillaSwapActive(KeyboardEvent event) {
        return Core.mc().options.keySwapOffhand.matches(event.key);
    }

    private static class DropFetcher
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            boolean blocked = false;
            try {
                if (!(msg instanceof ServerboundPlayerActionPacket)) {
                    return;
                }
                ServerboundPlayerActionPacket digging = (ServerboundPlayerActionPacket)msg;
                ServerboundPlayerActionPacket.Action action = digging.getAction();
                if (action != ServerboundPlayerActionPacket.Action.DROP_ITEM && action != ServerboundPlayerActionPacket.Action.DROP_ALL_ITEMS) {
                    return;
                }
                LockManager manager = Components.getComponent(LockManager.class);
                if (!manager.isLockedSlot(ContainerType.HOTBAR, Core.mc().player.getInventory().getSelectedSlot()) || KeyBindings.isBypass()) {
                    return;
                }
                blocked = true;
            }
            finally {
                if (!blocked) {
                    super.write(ctx, msg, promise);
                }
            }
        }
    }
}

