/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.input;

import com.kirdow.itemlocks.client.LockManager;
import com.kirdow.itemlocks.mixin.KeyMappingAccessor;
import com.kirdow.itemlocks.proxy.Components;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.enums.ContainerType;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class KeyBindings {
    public static KeyMapping keyLockHold;
    public static KeyMapping keyLockBypassHold;
    public static KeyMapping keyShowOptions;
    private static final MutableComponent ERROR_MESSAGE_TOGGLE;
    private static final MutableComponent ERROR_MESSAGE_BYPASS;
    private static final MutableComponent ERROR_MESSAGE_SHOW_OPTIONS;

    public static void init() {
        KeyMapping.Category category = new KeyMapping.Category(ResourceLocation.fromNamespaceAndPath((String)"ktnilcks", (String)"keys"));
        keyLockHold = new KeyMapping("key.ktnilcks.lock.toggle.hold", 67, category);
        keyLockBypassHold = new KeyMapping("key.ktnilcks.lock.bypass.hold", 66, category);
        keyShowOptions = new KeyMapping("key.ktnilcks.options.show", 78, category);
    }

    public static boolean isDropForbidden() {
        if (Core.isScreen()) {
            return false;
        }
        LockManager manager = Components.getComponent(LockManager.class);
        return manager.isLockedSlot(ContainerType.HOTBAR, Core.player().getInventory().getSelectedSlot()) && !KeyBindings.isBypass();
    }

    public static void register(Consumer<KeyMapping> registry) {
        registry.accept(keyLockHold);
        registry.accept(keyLockBypassHold);
        registry.accept(keyShowOptions);
    }

    private static boolean isDown(KeyMapping key) {
        int keyCode = ((KeyMappingAccessor)key).getKey().getValue();
        if (keyCode == -1) {
            return false;
        }
        Window window = Minecraft.getInstance().getWindow();
        return InputConstants.isKeyDown((Window)window, (int)keyCode);
    }

    public static boolean isToggle() {
        boolean result = false;
        try {
            result = KeyBindings.isDown(keyLockHold) && !KeyBindings.isBypass();
        }
        catch (IndexOutOfBoundsException ignored) {
            KeyBindings.resetKey(keyLockHold);
            KeyBindings.logError((Component)ERROR_MESSAGE_TOGGLE);
        }
        return result;
    }

    public static boolean isBypass() {
        boolean result = false;
        try {
            result = KeyBindings.isDown(keyLockBypassHold);
        }
        catch (IndexOutOfBoundsException ignored) {
            KeyBindings.resetKey(keyLockBypassHold);
            KeyBindings.logError((Component)ERROR_MESSAGE_BYPASS);
        }
        return result;
    }

    public static boolean isOptions() {
        boolean result = false;
        try {
            result = keyShowOptions.isDown();
        }
        catch (IndexOutOfBoundsException ignored) {
            KeyBindings.resetKey(keyShowOptions);
            KeyBindings.logError((Component)ERROR_MESSAGE_SHOW_OPTIONS);
        }
        return result;
    }

    private static void resetKey(KeyMapping key) {
        key.setKey(key.getDefaultKey());
    }

    private static void logError(Component message) {
        Gui ingame = Core.mc().gui;
        if (ingame != null) {
            ingame.getChat().addMessage(message);
        }
    }

    static {
        ERROR_MESSAGE_TOGGLE = Component.translatable((String)"error.key.ktnilcks.lock.toggle");
        ERROR_MESSAGE_BYPASS = Component.translatable((String)"error.key.ktnilcks.lock.toggle");
        ERROR_MESSAGE_SHOW_OPTIONS = Component.translatable((String)"error.key.ktnilcks.lock.toggle");
    }
}

