/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.util.reflect;

import com.kirdow.itemlocks.util.reflect.ReflectField;
import com.kirdow.itemlocks.util.reflect.ReflectMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;

public class ReflectClass {
    private static final ReflectClass NULL = new ReflectClass(null);
    private static Map<Class<?>, ReflectClass> cache = new HashMap();
    public final Class<?> clazz;

    public static ReflectClass forClass(Class<?> clazz) {
        if (clazz == null) {
            return NULL;
        }
        return cache.computeIfAbsent(clazz, key -> new ReflectClass((Class<?>)key));
    }

    public static ReflectClass forClass(String classname) {
        if (classname == null) {
            return NULL;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return ReflectClass.forClass(clazz);
    }

    public static ReflectClass forClass(String classname, Object ... formatArgs) {
        if (classname == null) {
            return NULL;
        }
        try {
            classname = String.format(classname, formatArgs);
        }
        catch (IllegalFormatException ignored) {
            return NULL;
        }
        return ReflectClass.forClass(classname);
    }

    private ReflectClass(Class<?> clazz) {
        this.clazz = clazz;
    }

    public boolean isNull() {
        return this.clazz == null;
    }

    public boolean isValid() {
        return this.clazz != null;
    }

    public int getDeclaredFieldCount() {
        if (this.clazz == null) {
            return 0;
        }
        return this.clazz.getDeclaredFields().length;
    }

    public int getDeclaredMethodCount() {
        if (this.clazz == null) {
            return 0;
        }
        return this.clazz.getDeclaredMethods().length;
    }

    public int getFieldCount() {
        if (this.clazz == null) {
            return 0;
        }
        return this.clazz.getFields().length;
    }

    public int getMethodCount() {
        if (this.clazz == null) {
            return 0;
        }
        return this.clazz.getMethods().length;
    }

    public ReflectField getDeclaredFieldAt(int index) {
        if (this.clazz == null) {
            return ReflectField.forField(null);
        }
        try {
            Field field = this.clazz.getDeclaredFields()[index];
            return ReflectField.forField(field);
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            return ReflectField.forField(null);
        }
    }

    public ReflectMethod getDeclaredMethodAt(int index) {
        if (this.clazz == null) {
            return ReflectMethod.forMethod(null);
        }
        try {
            Method method = this.clazz.getDeclaredMethods()[index];
            return ReflectMethod.forMethod(method);
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            return ReflectMethod.forMethod(null);
        }
    }

    public ReflectField getFieldAt(int index) {
        if (this.clazz == null) {
            return ReflectField.forField(null);
        }
        try {
            Field field = this.clazz.getFields()[index];
            return ReflectField.forField(field);
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            return ReflectField.forField(null);
        }
    }

    public ReflectMethod getMethodAt(int index) {
        if (this.clazz == null) {
            return ReflectMethod.forMethod(null);
        }
        try {
            Method method = this.clazz.getMethods()[index];
            return ReflectMethod.forMethod(method);
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            return ReflectMethod.forMethod(null);
        }
    }

    public ReflectField getDeclaredFieldByName(String name) {
        if (this.clazz == null || name == null) {
            return ReflectField.forField(null);
        }
        try {
            Field field = this.clazz.getDeclaredField(name);
            return ReflectField.forField(field);
        }
        catch (NoSuchFieldException e) {
            return ReflectField.forField(null);
        }
    }

    public ReflectMethod getDeclaredMethodByName(String name, Class<?> ... classes) {
        if (this.clazz == null || classes == null) {
            return ReflectMethod.forMethod(null);
        }
        try {
            Method method = this.clazz.getDeclaredMethod(name, classes);
            return ReflectMethod.forMethod(method);
        }
        catch (NoSuchMethodException e) {
            return ReflectMethod.forMethod(null);
        }
    }

    public ReflectField getFieldByName(String name) {
        if (this.clazz == null || name == null) {
            return ReflectField.forField(null);
        }
        try {
            Field field = this.clazz.getField(name);
            return ReflectField.forField(field);
        }
        catch (NoSuchFieldException e) {
            return ReflectField.forField(null);
        }
    }

    public ReflectMethod getMethodByName(String name, Class<?> ... classes) {
        if (this.clazz == null || classes == null) {
            return ReflectMethod.forMethod(null);
        }
        try {
            Method method = this.clazz.getMethod(name, classes);
            return ReflectMethod.forMethod(method);
        }
        catch (NoSuchMethodException e) {
            return ReflectMethod.forMethod(null);
        }
    }

    public boolean clone(Object src, Object dst) {
        Class<?> clazz = this.clazz;
        Field modifiersField = null;
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        modifiersField.setAccessible(true);
        do {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    modifiersField.setInt(field, modifiersField.getInt(field) & 0xFFFFFFEF);
                    field.set(dst, field.get(src));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return true;
    }

    public boolean is(Class<?> clazz) {
        return this.is(ReflectClass.forClass(clazz));
    }

    public boolean isExact(Class<?> clazz) {
        return this.isExact(ReflectClass.forClass(clazz));
    }

    public boolean is(ReflectClass clazz) {
        return this.clazz.isAssignableFrom(clazz.clazz);
    }

    public boolean isExact(ReflectClass clazz) {
        return this.clazz == clazz.clazz;
    }
}

