/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.util;

import java.util.Arrays;

public class Version {
    private String version = null;
    private final int[] points;

    public Version(String version) {
        if (version == null) {
            this.points = new int[0];
        } else {
            String[] points = version.split("\\.");
            this.points = new int[points.length];
            for (int index = 0; index < points.length; ++index) {
                try {
                    this.points[index] = Integer.parseInt(points[index]);
                    continue;
                }
                catch (NumberFormatException ignored) {
                    this.points[index] = 0;
                }
            }
        }
    }

    public Version(int[] points) {
        this.points = points == null ? new int[0] : Arrays.copyOf(points, points.length);
    }

    public int compareTo(Version b) {
        int[] arrayA = this.points;
        int[] arrayB = b.points;
        int size = Math.max(arrayA.length, arrayB.length);
        for (int index = 0; index < size; ++index) {
            int valueB;
            int valueA = index >= arrayA.length ? 0 : arrayA[index];
            int test = valueA - (valueB = index >= arrayB.length ? 0 : arrayB[index]);
            if (test == 0) continue;
            return test < 0 ? -1 : 1;
        }
        return 0;
    }

    public int[] getPoints() {
        return Arrays.copyOf(this.points, this.points.length);
    }

    public String getVersion() {
        return this.toString();
    }

    public String toString() {
        if (this.version != null) {
            return this.version;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < this.points.length; ++index) {
            if (index > 0) {
                sb.append('.');
            }
            sb.append(this.points[index]);
        }
        this.version = sb.toString();
        return this.version;
    }
}

