/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.render;

import com.kirdow.itemlocks.ItemLocks;
import com.kirdow.itemlocks.client.LockManager;
import com.kirdow.itemlocks.client.input.KeyBindings;
import com.kirdow.itemlocks.client.render.ELockModifier;
import com.kirdow.itemlocks.client.render.Res;
import com.kirdow.itemlocks.config.ConfigManager;
import com.kirdow.itemlocks.fabric.MixinHelper;
import com.kirdow.itemlocks.proxy.Components;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.enums.ContainerType;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_4668;

public class RenderContainer {
    private static LockManager manager = null;
    public static final String ILTTP = "\u00a76ItemLocks\u00a78: \u00a7a";
    private static final class_4587 ms = new class_4587();
    private static final Function<class_2960, class_1921> TYPE_RENDER_GUI = class_156.method_34866(resource -> class_1921.method_24048((String)"ktn_texture_gui", (int)786432, (RenderPipeline)class_10799.field_56883, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(resource, false)).method_23617(false)));
    private static final RenderPipeline PIPE_RENDER_GUI = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation(class_2960.method_60655((String)"ktnilcks", (String)"pipeline/gui_textured")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).build());

    private static LockManager getManager() {
        if (manager != null) {
            return manager;
        }
        manager = Components.getComponent(LockManager.class);
        return manager;
    }

    public static void drawScreen(class_465 screen, class_332 ctx) {
        int y;
        int x;
        LockManager manager = RenderContainer.getManager();
        class_1735 hoveredSlot = MixinHelper.getFocusedSlot(screen);
        boolean mode = KeyBindings.isToggle();
        class_2371 slots = screen.method_17577().field_7761;
        ContainerType containerType = ContainerType.match(screen);
        class_1661 playerInventory = Core.player().method_31548();
        boolean bypass = KeyBindings.isBypass() || ConfigManager.get().bypassAll || !screen.method_17577().method_34255().method_7960() && ConfigManager.get().bypassHeld;
        boolean unlockedSlots = false;
        for (class_1735 slot : slots) {
            if (slot.field_7871 != playerInventory || !manager.isLockedSlot(containerType, slot.method_34266())) continue;
            boolean unlock = mode && hoveredSlot == slot;
            x = slot.field_7873;
            y = slot.field_7872;
            if (bypass && hoveredSlot == slot) {
                RenderContainer.drawLock(ctx, x, y, unlock ? ELockModifier.LiftedUnlocked : ELockModifier.Unlocked);
                continue;
            }
            if (slot.method_7681()) {
                RenderContainer.drawLock(ctx, x, y, unlock ? ELockModifier.LiftedLocked : ELockModifier.Locked);
                continue;
            }
            RenderContainer.drawLock(ctx, x, y, unlock ? ELockModifier.LiftedUnlocked : ELockModifier.Unlocked);
            unlockedSlots = true;
        }
        if (unlockedSlots && ItemLocks.hasTips()) {
            x = 8;
            y = 8 + MixinHelper.getYSize(screen);
            String[] strs = Core.player().method_31548().method_7391() != null ? new String[]{"\u00a76ItemLocks\u00a78: \u00a7aEmpty slots with a lock are", "shown unlocked, allowing to place", "held items in those slots!"} : new String[]{"\u00a76ItemLocks\u00a78: \u00a7aUnlock empty slots by holding", "lock key and pressing LMB"};
            for (String str : strs) {
                class_327 font = Core.mc().field_1772;
                ctx.method_51439(font, (class_2561)class_2561.method_43470((String)str), x, y, class_124.field_1060.method_532().intValue(), true);
                Objects.requireNonNull(Core.mc().field_1772);
                y += 9 + 2;
            }
        }
    }

    public static void drawHotbar(class_332 ctx, LockManager manager) {
        if (!ConfigManager.get().hotbarVisible) {
            return;
        }
        int width = Core.mc().method_22683().method_4486();
        int height = Core.mc().method_22683().method_4502();
        int x = width / 2 - 87;
        int y = height - 18;
        for (int i = 0; i < 9; ++i) {
            if (!manager.isLockedSlot(ContainerType.HOTBAR, i)) continue;
            if (!Core.player().method_31548().method_5438(i).method_7960()) {
                RenderContainer.drawLock(ctx, x + i * 20, y, KeyBindings.isBypass() ? ELockModifier.LiftedLocked : ELockModifier.Locked);
                continue;
            }
            RenderContainer.drawLock(ctx, x + i * 20, y, ELockModifier.Unlocked);
        }
    }

    public static void drawLock(class_332 ctx, int x, int y, ELockModifier modifier) {
        int posX = x + 12;
        int posY = y - 4;
        switch (modifier) {
            case Locked: {
                RenderContainer.drawScaledCustomSizeModalRect(ctx, posX, posY, 0.0f, 16.0f, 6, 11, 6, 11, 256, 256);
                break;
            }
            case Unlocked: {
                RenderContainer.drawScaledCustomSizeModalRect(ctx, posX, posY, 16.0f, 16.0f, 10, 11, 10, 11, 256, 256);
                break;
            }
            case LiftedLocked: {
                RenderContainer.drawScaledCustomSizeModalRect(ctx, posX, posY - 1, 0.0f, 16.0f, 6, 5, 6, 5, 256, 256);
                RenderContainer.drawScaledCustomSizeModalRect(ctx, posX, posY + 5, 0.0f, 21.0f, 6, 6, 6, 6, 256, 256);
                break;
            }
            case LiftedUnlocked: {
                RenderContainer.drawScaledCustomSizeModalRect(ctx, posX, posY - 1, 16.0f, 16.0f, 10, 5, 10, 5, 256, 256);
                RenderContainer.drawScaledCustomSizeModalRect(ctx, posX, posY + 5, 16.0f, 21.0f, 6, 6, 6, 6, 256, 256);
            }
        }
    }

    public static void drawScaledCustomSizeModalRect(class_332 ctx, int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, int tileWidth, int tileHeight) {
        ctx.method_25302(PIPE_RENDER_GUI, Res.TEXTURE_ICONS, x, y, u, v, uWidth, vHeight, width, height, tileWidth, tileHeight);
    }
}

