/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.gui;

import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.Utils;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;

public class Label
extends AbstractWidget {
    private HAnchor anchorX = HAnchor.LEFT;
    private VAnchor anchorY = VAnchor.TOP;
    private int color = 0xF0F0F0;
    private Consumer<Label> hoverConsumer;
    private static Label onHover;

    public Label(int x, int y, int width, int height, Component component) {
        super(x, y, width, height, component);
    }

    public void setHoverCallback(Consumer<Label> callback) {
        this.hoverConsumer = callback;
    }

    public void setAnchorX(HAnchor anchor) {
        this.anchorX = anchor;
    }

    public void setAnchorY(VAnchor anchor) {
        this.anchorY = anchor;
    }

    public void setColor(int r, int g, int b) {
        this.color = Utils.clamp(r, 0, 255) << 16 | Utils.clamp(g, 0, 255) << 8 | Utils.clamp(b, 0, 255);
    }

    public void setColor(int color) {
        this.setColor(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public void updateWidgetNarration(NarrationElementOutput neo) {
        neo.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"ktnilcks.narration.label", (Object[])new Object[]{this.getMessage()}));
    }

    public void renderWidget(GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        HoverEvent event;
        Component text;
        block14: {
            block13: {
                Font font = Core.mc().font;
                text = this.getMessage();
                int textWidth = font.width(text.getString());
                int tx = this.getX();
                int ty = this.getY();
                int x = switch (this.anchorX.ordinal()) {
                    case 2 -> tx - textWidth;
                    case 1 -> tx - textWidth / 2;
                    default -> tx;
                };
                int y = switch (this.anchorY.ordinal()) {
                    case 2 -> {
                        Objects.requireNonNull(font);
                        yield ty - 9;
                    }
                    case 1 -> {
                        Objects.requireNonNull(font);
                        yield ty - 9 / 2;
                    }
                    default -> ty;
                };
                ctx.drawString(font, text, x, y, this.color, true);
                if (mouseX < x - 10 || mouseY < y - 10 || mouseX > x + textWidth + 10) break block13;
                Objects.requireNonNull(font);
                if (mouseY <= y + 9 + 10) break block14;
            }
            return;
        }
        if (onHover == this) {
            // empty if block
        }
        if ((event = text.getStyle().getHoverEvent()) != null) {
            onHover = this;
        }
    }

    public static enum HAnchor {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VAnchor {
        TOP,
        CENTER,
        BOTTOM;

    }
}

