/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.update;

import com.kirdow.itemlocks.Logger;
import com.kirdow.itemlocks.client.update.UpdateCache;
import com.kirdow.itemlocks.client.update.UpdateMessage;
import com.kirdow.itemlocks.common.Reference;
import com.kirdow.itemlocks.config.ConfigManager;
import com.kirdow.itemlocks.util.ILVersion;
import com.kirdow.itemlocks.util.ILVersionMode;
import com.kirdow.itemlocks.util.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class UpdateManager {
    public static final UpdateManager UPDATE_MANAGER = new UpdateManager();
    private final Version version = new Version("1.3.11");
    private final UpdateCache updateCache = new UpdateCache(this::checkForUpdate);
    private static final UpdateMessage updateMessage = new UpdateMessage();
    public static ILVersionMode versionMode = ILVersionMode.UNSUPPORTED;

    public void checkAndNotifyAsync() {
        new Thread(() -> {
            boolean newUpdate = this.isUpdateAvailable();
            updateMessage.setMessage(newUpdate);
        }).start();
    }

    public boolean isUpdateAvailable() {
        return !this.updateCache.run(150000L);
    }

    public boolean checkForUpdate() {
        boolean upToDate;
        Logger.info("Checking for updates!", new Object[0]);
        String ilVersionFile = UpdateManager.downloadVersionString().trim();
        ILVersion.parseVersionsFromILVersionFormat(ilVersionFile);
        versionMode = ILVersion.getModeFromVersion(this.version);
        boolean bl = upToDate = !versionMode.isUnsupported();
        if (upToDate) {
            Logger.info("ItemLocks is up to date!", new Object[0]);
        } else {
            Logger.error("ItemLocks is outdated!", new Object[0]);
        }
        return upToDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadVersionString() {
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            URI resourceIdentifier = new URI("https://itemlocks.com/versions.ilversion");
            URL resourceLocator = resourceIdentifier.toURL();
            reader = new BufferedReader(new InputStreamReader(resourceLocator.openStream()));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        catch (IOException | URISyntaxException ex) {
            Logger.exception(ex);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        return sb.toString();
    }

    public static void queryOutdated() {
        updateMessage.query(outdated -> {
            if (outdated && ConfigManager.get().notifyChat) {
                Reference.logInChat("A new update for ItemLocks is available.", new Object[0]);
                ILVersion.getLatest().ifPresentOrElse(latest -> Reference.logInChat("You're using %s which is %s. Please update to %s.", UpdateManager.UPDATE_MANAGER.version.getVersion(), versionMode.getName().toLowerCase(), latest.getVersion()), () -> Reference.logInChat("You're using %s which is %s.", UpdateManager.UPDATE_MANAGER.version.getVersion(), versionMode.getName().toLowerCase()));
            }
        });
    }
}

