/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.common;

public class MouseEvent {
    public final EMouseAction action;
    public final EMouseButton button;

    public MouseEvent(EMouseAction action, EMouseButton button) {
        this.action = action;
        this.button = button;
    }

    public static enum EMouseAction {
        Click(true),
        Release(false);

        public final boolean isPress;
        public final boolean isRelease;

        private EMouseAction(boolean press) {
            this.isPress = press;
            this.isRelease = !press;
        }
    }

    public static enum EMouseButton {
        Left(0),
        Right(1),
        Middle(2),
        M4(3),
        M5(4);

        public final int index;
        public final boolean isLeft;
        public final boolean isRight;
        public final boolean isMiddle;
        public final boolean isM4;
        public final boolean isM5;

        private EMouseButton(int index) {
            this.index = index;
            this.isLeft = index == 0;
            this.isRight = index == 1;
            this.isMiddle = index == 2;
            this.isM4 = index == 3;
            this.isM5 = index == 4;
        }

        public static EMouseButton of(int buttonId) {
            return switch (buttonId) {
                case 0 -> Left;
                case 1 -> Right;
                case 2 -> Middle;
                case 3 -> M4;
                case 5 -> M5;
                default -> null;
            };
        }
    }
}

