/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.util;

import com.kirdow.itemlocks.Logger;
import com.kirdow.itemlocks.util.ILVersionMode;
import com.kirdow.itemlocks.util.Version;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ILVersion {
    private static ILVersionMode _mode = null;
    private static final Map<ILVersionMode, List<Version>> versions = new HashMap<ILVersionMode, List<Version>>();
    private static final Map<Version, ILVersionMode> cache = new HashMap<Version, ILVersionMode>();

    private static List<Version> getVersion(ILVersionMode mode) {
        if (mode == null) {
            return null;
        }
        return versions.computeIfAbsent(mode, key -> new ArrayList());
    }

    private static void setMode(ILVersionMode mode) {
        _mode = mode == ILVersionMode.UNSUPPORTED ? null : mode;
    }

    private static void add(Version version) {
        List<Version> list = ILVersion.getVersion(_mode);
        if (list == null) {
            return;
        }
        list.add(version);
        cache.put(version, _mode);
    }

    public static ILVersionMode getModeFromVersion(Version version) {
        return cache.getOrDefault(version, ILVersionMode.UNSUPPORTED);
    }

    public static Optional<Version> getLatest() {
        List<Version> list = ILVersion.getVersion(ILVersionMode.LATEST);
        if (list == null) {
            return Optional.empty();
        }
        return list.stream().max(Comparator.naturalOrder());
    }

    public static void parseVersionsFromILVersionFormat(String file) {
        String remoteVersions = file.trim();
        for (String remoteLine : remoteVersions.split("\n")) {
            Version remoteVersion;
            String line = remoteLine.trim();
            if (line.isEmpty()) continue;
            if (line.startsWith("#X: ")) {
                String channel = line.substring(4);
                try {
                    ILVersionMode mode = ILVersionMode.valueOf(channel.toUpperCase());
                    ILVersion.setMode(mode);
                }
                catch (IllegalArgumentException ex) {
                    Logger.error("Failed to parse ILVersionMode: %s", channel);
                    Logger.exception(ex);
                }
                continue;
            }
            if (line.startsWith("#") || !(remoteVersion = new Version(line)).getVersion().equals(line)) continue;
            ILVersion.add(remoteVersion);
        }
        ILVersion.setMode(ILVersionMode.UNSUPPORTED);
    }
}

