/*
 * Decompiled with CFR 0.152.
 */
package com.kirdow.itemlocks.client.render;

import com.kirdow.itemlocks.ItemLocks;
import com.kirdow.itemlocks.client.LockManager;
import com.kirdow.itemlocks.client.input.KeyBindings;
import com.kirdow.itemlocks.client.render.ELockModifier;
import com.kirdow.itemlocks.client.render.Res;
import com.kirdow.itemlocks.config.ConfigManager;
import com.kirdow.itemlocks.forge.MixinHelper;
import com.kirdow.itemlocks.proxy.Components;
import com.kirdow.itemlocks.util.Core;
import com.kirdow.itemlocks.util.enums.ContainerType;
import com.kirdow.itemlocks.util.reflect.ReflectUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.CoreShaders;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RenderContainer {
    private static LockManager manager = null;
    public static final String ILTTP = "\u00a76ItemLocks\u00a78: \u00a7a";
    private static final PoseStack ms = new PoseStack();

    private static LockManager getManager() {
        if (manager != null) {
            return manager;
        }
        manager = Components.getComponent(LockManager.class);
        return manager;
    }

    public static void drawScreen(AbstractContainerScreen screen, GuiGraphics ctx) {
        int y;
        int x;
        LockManager manager = RenderContainer.getManager();
        Slot hoveredSlot = screen.getSlotUnderMouse();
        boolean mode = KeyBindings.isToggle();
        GlStateManager._enableBlend();
        GlStateManager._clear((int)256);
        NonNullList slots = screen.getMenu().slots;
        ContainerType containerType = ContainerType.match(screen);
        Inventory playerInventory = Core.mc().player.getInventory();
        boolean bypass = KeyBindings.isBypass() || ConfigManager.get().bypassAll || !screen.getMenu().getCarried().isEmpty() && ConfigManager.get().bypassHeld;
        boolean unlockedSlots = false;
        for (Slot slot : slots) {
            if (slot.container != playerInventory || !manager.isLockedSlot(containerType, slot.getSlotIndex())) continue;
            boolean unlock = mode && hoveredSlot == slot;
            x = slot.x + MixinHelper.getX(screen);
            y = slot.y + MixinHelper.getY(screen);
            if (bypass && hoveredSlot == slot) {
                RenderContainer.drawLock(ctx, x, y, unlock ? ELockModifier.LiftedUnlocked : ELockModifier.Unlocked);
                continue;
            }
            if (slot.hasItem()) {
                RenderContainer.drawLock(ctx, x, y, unlock ? ELockModifier.LiftedLocked : ELockModifier.Locked);
                continue;
            }
            RenderContainer.drawLock(ctx, x, y, unlock ? ELockModifier.LiftedUnlocked : ELockModifier.Unlocked);
            unlockedSlots = true;
        }
        if (unlockedSlots && ItemLocks.hasTips()) {
            x = 8;
            y = 8 + ReflectUtil.getYSize(screen);
            String[] strs = Core.player().getInventory().getSelected() != null ? new String[]{"\u00a76ItemLocks\u00a78: \u00a7aEmpty slots with a lock are", "shown unlocked, allowing to place", "held items in those slots!"} : new String[]{"\u00a76ItemLocks\u00a78: \u00a7aUnlock empty slots by holding", "lock key and pressing LMB"};
            for (String str : strs) {
                Font font = Core.mc().font;
                ctx.drawString(font, (Component)Component.literal((String)str), x, y, ChatFormatting.GREEN.getColor().intValue(), true);
                Objects.requireNonNull(Core.mc().font);
                y += 9 + 2;
            }
        }
    }

    public static void drawHotbar(GuiGraphics ctx, LockManager manager) {
        if (!ConfigManager.get().hotbarVisible) {
            return;
        }
        int width = Core.mc().getWindow().getGuiScaledWidth();
        int height = Core.mc().getWindow().getGuiScaledHeight();
        int x = width / 2 - 87;
        int y = height - 18;
        GlStateManager._disableDepthTest();
        for (int i = 0; i < 9; ++i) {
            if (!manager.isLockedSlot(ContainerType.HOTBAR, i)) continue;
            if (!((ItemStack)Core.player().getInventory().items.get(i)).isEmpty()) {
                RenderContainer.drawLock(ctx, x + i * 20, y, KeyBindings.isBypass() ? ELockModifier.LiftedLocked : ELockModifier.Locked);
                continue;
            }
            RenderContainer.drawLock(ctx, x + i * 20, y, ELockModifier.Unlocked);
        }
        GlStateManager._enableDepthTest();
    }

    public static void drawLock(GuiGraphics ctx, int x, int y, ELockModifier modifier) {
        int posX = x + 12;
        int posY = y - 4;
        switch (modifier) {
            case Locked: {
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY, 0, 16, 6, 11, 6.0f, 11.0f, 256.0f, 256.0f);
                break;
            }
            case Unlocked: {
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY, 16, 16, 10, 11, 10.0f, 11.0f, 256.0f, 256.0f);
                break;
            }
            case LiftedLocked: {
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY - 1, 0, 16, 6, 5, 6.0f, 5.0f, 256.0f, 256.0f);
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY + 5, 0, 21, 6, 6, 6.0f, 6.0f, 256.0f, 256.0f);
                break;
            }
            case LiftedUnlocked: {
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY - 1, 16, 16, 10, 5, 10.0f, 6.0f, 256.0f, 256.0f);
                RenderContainer.drawScaledCustomSizeModalRect(posX, posY + 5, 16, 21, 6, 6, 6.0f, 6.0f, 256.0f, 256.0f);
            }
        }
    }

    public static void drawScaledCustomSizeModalRect(float x, float y, int u, int v, int uWidth, int vHeight, float width, float height, float tileWidth, float tileHeight) {
        RenderSystem.setShader((ShaderProgram)CoreShaders.POSITION_TEX);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Res.TEXTURE_ICONS);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(x, y + height, 0.0f).setUv((float)u * f, ((float)v + (float)vHeight) * f1);
        bufferbuilder.addVertex(x + width, y + height, 0.0f).setUv(((float)u + (float)uWidth) * f, ((float)v + (float)vHeight) * f1);
        bufferbuilder.addVertex(x + width, y, 0.0f).setUv(((float)u + (float)uWidth) * f, (float)v * f1);
        bufferbuilder.addVertex(x, y, 0.0f).setUv((float)u * f, (float)v * f1);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }
}

