/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.config;

import com.shynieke.ageingmobs.AgeingMobs;
import java.util.Arrays;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class AgeingConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        AgeingMobs.LOGGER.debug("Loaded Ageing Mobs' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        AgeingMobs.LOGGER.warn("Ageing Mobs' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue creeperAgeing;
        public final ModConfigSpec.IntValue creeperAgeingTime;
        public final ModConfigSpec.BooleanValue zombieToHuskAgeing;
        public final ModConfigSpec.IntValue zombieToHuskAgeingTime;
        public final ModConfigSpec.BooleanValue huskToZombieAgeing;
        public final ModConfigSpec.IntValue huskToZombieAgeingTime;
        public final ModConfigSpec.BooleanValue passivePillagerToVillagerAgeing;
        public final ModConfigSpec.IntValue passivePillagerToVillagerAgeingTime;
        public final ModConfigSpec.BooleanValue villagerToVindicatorAgeing;
        public final ModConfigSpec.IntValue villagerToVindicatorAgeingTime;
        public final ModConfigSpec.IntValue villagerToVindicatorMinLight;
        public final ModConfigSpec.IntValue villagerToVindicatorMaxLight;
        public final ModConfigSpec.BooleanValue vindicatorToEvokerAgeing;
        public final ModConfigSpec.IntValue vindicatorToEvokerAgeingTime;
        public final ModConfigSpec.BooleanValue guardianToElderAgeing;
        public final ModConfigSpec.IntValue guardianToElderAgeingTime;
        public final ModConfigSpec.IntValue guardianToElderAgeingMax;
        public final ModConfigSpec.IntValue guardianToElderRange;
        public final ModConfigSpec.BooleanValue babyToZombieAgeing;
        public final ModConfigSpec.IntValue babyToZombieAgeingTime;
        public final ModConfigSpec.BooleanValue skeletonToStrayAgeing;
        public final ModConfigSpec.IntValue skeletonToStrayAgeingTime;
        public final ModConfigSpec.BooleanValue strayToSkeletonAgeing;
        public final ModConfigSpec.IntValue strayToSkeletonAgeingTime;
        public final ModConfigSpec.BooleanValue rabbitToKillerAgeing;
        public final ModConfigSpec.IntValue rabbitToKillerAgeingTime;
        public final ModConfigSpec.IntValue rabbitToKillerMinLight;
        public final ModConfigSpec.IntValue rabbitToKillerMaxLight;
        public final ModConfigSpec.BooleanValue cowToMooshroomAgeing;
        public final ModConfigSpec.IntValue cowToMooshroomAgeingTime;
        public final ModConfigSpec.IntValue cowToMooshroomAgeingRadius;
        public final ModConfigSpec.BooleanValue skeletonToWitherSkeletonAgeing;
        public final ModConfigSpec.IntValue skeletonToWitherSkeletonAgeingTime;
        public final ModConfigSpec.BooleanValue slimeToMagmaCubeAgeing;
        public final ModConfigSpec.IntValue slimeToMagmaCubeAgeingTime;
        public final ModConfigSpec.BooleanValue batToVexAgeing;
        public final ModConfigSpec.IntValue batToVexAgeingTime;
        public final ModConfigSpec.ConfigValue<List<? extends String>> magical_blocks;
        public final ModConfigSpec.ConfigValue<List<? extends String>> moon_dimensions;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Creeper -> Charged Creeper").push("creeper_to_charged");
            this.creeperAgeing = builder.comment("Setting this to false disables the creeper -> charged creeper ageing (Default: true)").define("creeperAgeing", true);
            this.creeperAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 900)").defineInRange("creeperAgeingTime", 900, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Zombie -> Husk").push("zombie_to_husk");
            this.zombieToHuskAgeing = builder.comment("Setting this to false disables the zombie -> husk ageing (Default: true)").define("zombieToHuskAgeing", true);
            this.zombieToHuskAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 30)").defineInRange("zombieToHuskAgeingTime", 30, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Husk -> Zombie").push("husk_to_zombie");
            this.huskToZombieAgeing = builder.comment("Setting this to false disables the husk -> zombie ageing (Default: true)").define("huskToZombieAgeing", true);
            this.huskToZombieAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 30)").defineInRange("huskToZombieAgeingTime", 30, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Passive Pillager -> Villager").push("passive_pillager_to_villager");
            this.passivePillagerToVillagerAgeing = builder.comment("Setting this to false disables the pillager -> villager ageing if the pillager is not holding a bow-like item (Default: true)").define("passivePillagerToVillagerAgeing", true);
            this.passivePillagerToVillagerAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 300)").defineInRange("passivePillagerToVillagerAgeingTime", 300, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Villager -> Vindicator").push("villager_to_vindicator");
            this.villagerToVindicatorAgeing = builder.comment("Setting this to false disables the villager -> vindicator ageing (Default: true)").define("villagerToVindicatorAgeing", true);
            this.villagerToVindicatorAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 1200)").defineInRange("villagerToVindicatorAgeingTime", 1200, 1, Integer.MAX_VALUE);
            this.villagerToVindicatorMinLight = builder.comment("This specifies the minimum light level from which the mob starts to age (Default: 0)").defineInRange("villagerToVindicatorMinLight", 0, 0, 15);
            this.villagerToVindicatorMaxLight = builder.comment("This specifies the maximum light level from which the mob starts to age (Default: 8)").defineInRange("villagerToVindicatorMaxLight", 8, 0, 15);
            builder.pop();
            builder.comment("Vindicator -> Evoker").push("vindicator_to_evoker");
            this.vindicatorToEvokerAgeing = builder.comment("Setting this to false disables the vindicator -> evoker ageing (Default: true)").define("vindicatorToEvokerAgeing", true);
            this.vindicatorToEvokerAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 600)").defineInRange("vindicatorToEvokerAgeingTime", 600, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Guardian -> Elder Guardian").push("guardian_to_elder_guardian");
            this.guardianToElderAgeing = builder.comment("Setting this to false disables the guardian -> elder ageing (Default: true)").define("guardianToElderAgeing", true);
            this.guardianToElderAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 1800)").defineInRange("guardianToElderAgeingTime", 1800, 1, Integer.MAX_VALUE);
            this.guardianToElderAgeingMax = builder.comment("This specifies max amount of elder guardians in the area, 0 = infinite (Default: 2)").defineInRange("guardianToElderAgeingMax", 2, 0, Integer.MAX_VALUE);
            this.guardianToElderRange = builder.comment("This specifies radius (not the diameter) around the original mob in which it checks for the boss mob, 16 = infinite (Default: 16)").defineInRange("guardianToElderRange", 16, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Baby Zombie -> Zombie").push("baby_zombie_to_zombie");
            this.babyToZombieAgeing = builder.comment("Setting this to false disables the baby -> zombie ageing (Default: true)").define("babyToZombieAgeing", true);
            this.babyToZombieAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 1200)").defineInRange("babyToZombieAgeingTime", 1200, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Endermite -> Shulker").push("endermite_to_shulker");
            builder.pop();
            builder.comment("Skeleton -> Stray").push("skeleton_to_stray");
            this.skeletonToStrayAgeing = builder.comment("Setting this to false disables the skeleton -> stray ageing (Default: true)").define("skeletonToStrayAgeing", true);
            this.skeletonToStrayAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 30)").defineInRange("skeletonToStrayAgeingTime", 30, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Stray -> Skeleton").push("stray_to_skeleton");
            this.strayToSkeletonAgeing = builder.comment("Setting this to false disables the stray -> skeleton ageing (Default: true)").define("strayToSkeletonAgeing", true);
            this.strayToSkeletonAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 30)").defineInRange("strayToSkeletonAgeingTime", 30, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Skeleton -> Wither Skeleton").push("skeleton_wither_skeleton");
            this.skeletonToWitherSkeletonAgeing = builder.comment("Setting this to false disables the skeleton -> wither skeleton ageing (Default: true)").define("skeletonToWitherSkeletonAgeing", true);
            this.skeletonToWitherSkeletonAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 120)").defineInRange("skeletonToWitherSkeletonAgeingTime", 120, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Rabbit -> Killer").push("rabbit_to_killer_rabbit");
            this.rabbitToKillerAgeing = builder.comment("Setting this to false disables the rabbit -> killer rabbit ageing (Default: true)").define("rabbitToKillerAgeing", true);
            this.rabbitToKillerAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 300)").defineInRange("rabbitToKillerAgeingTime", 300, 1, Integer.MAX_VALUE);
            this.rabbitToKillerMinLight = builder.comment("TThis specifies the minimum light level from which the mob starts to age (Default: 0)").defineInRange("rabbitToKillerMinLight", 0, 0, 15);
            this.rabbitToKillerMaxLight = builder.comment("This specifies the maximum light level from which the mob starts to age (Default: 3)").defineInRange("rabbitToKillerMaxLight", 3, 0, 15);
            builder.pop();
            builder.comment("Cow -> Mooshroom").push("cow_to_mooshroom");
            this.cowToMooshroomAgeing = builder.comment("Setting this to false disables the cow -> mooshroom ageing (Default: true)").define("cowToMooshroomAgeing", true);
            this.cowToMooshroomAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 900)").defineInRange("cowToMooshroomAgeingTime", 900, 1, Integer.MAX_VALUE);
            this.cowToMooshroomAgeingRadius = builder.comment("This specifies radius (not the diameter) around the original mob in which it checks for magic blocks (Default: 5)").defineInRange("cowToMooshroomAgeingRadius", 5, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Slime -> Magma Cube").push("slime_to_magma_cube");
            this.slimeToMagmaCubeAgeing = builder.comment("Setting this to false disables the slime -> magma cube ageing (Default: true)").define("slimeToMagmaCubeAgeing", true);
            this.slimeToMagmaCubeAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 120)").defineInRange("slimeToMagmaCubeAgeingTime", 120, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Bat -> Vex").push("bat_to_vex");
            this.batToVexAgeing = builder.comment("Setting this to false disables the bat -> vex ageing (Default: true)").define("batToVexAgeing", true);
            this.batToVexAgeingTime = builder.comment("This specifies the time in second(s) which dictates how long a mob needs to age (Default: 666)").defineInRange("batToVexAgeingTime", 666, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Other settings").push("other");
            String[] magicalList = new String[]{"minecraft:bookshelf;0.2", "minecraft:brewing_stand;0.5", "minecraft:enchanting_table;1"};
            this.magical_blocks = builder.comment("Blocks that are seen as magical, by removing the blocks they won't be seen as magical by the mod. syntax: modid:block;effectiveness").defineListAllowEmpty("magical_blocks", Arrays.asList(magicalList), String::new, o -> o instanceof String);
            String[] dimensionList = new String[]{"minecraft:overworld"};
            this.moon_dimensions = builder.comment("Dimensions that the mod recognizes having a moon. By default only has the overworld").defineListAllowEmpty("moon_dimensions", Arrays.asList(dimensionList), String::new, o -> o instanceof String);
            builder.pop();
        }
    }
}

