/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.handler;

import com.shynieke.ageingmobs.AgeingMobs;
import com.shynieke.ageingmobs.handler.GamestagesHandler;
import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.AgeingData;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class AgeHandler {
    @SubscribeEvent
    public void handleAgeing(LevelTickEvent.Post event) {
        ServerLevel serverLevel;
        Level level = event.getLevel();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).dimension() == Level.OVERWORLD && serverLevel.getGameTime() % 20L == 0L && !AgeingRegistry.ageingList.isEmpty()) {
            for (Entity entityIn : serverLevel.getEntities().getAll()) {
                ResourceLocation entityLocation;
                if (entityIn == null || (entityLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityIn.getType())) == null || !AgeingRegistry.hasEntityAgeing(entityLocation)) continue;
                List<AgeingData> dataList = AgeingRegistry.getDataList(entityLocation);
                for (AgeingData info : dataList) {
                    if (entityIn == null || entityIn instanceof Player || entityIn.getType() == null || info.getEntity() == null || !entityIn.getType().equals(info.getEntity())) continue;
                    if (info.getTransformedEntity() != null && info.getEntity().equals(info.getTransformedEntity())) {
                        if (!info.getTransformedEntityData().isEmpty()) {
                            this.checkList(info, entityIn, (Level)serverLevel);
                            continue;
                        }
                        AgeingMobs.LOGGER.error("An error has occured. A mob can not transform into itself. See id: {}", (Object)info.getName());
                        AgeingRegistry.INSTANCE.removeAgeing(info);
                        continue;
                    }
                    this.checkList(info, entityIn, (Level)serverLevel);
                }
            }
        }
    }

    public void checkList(AgeingData info, Entity entity, Level level) {
        boolean matchesOriginalData;
        CompoundTag entityTag = AgeingRegistry.entityToNBT(entity);
        CompoundTag originalData = info.getEntityData();
        CompoundTag transformedData = info.getTransformedEntityData();
        boolean sameEntityType = info.getEntity().equals(info.getTransformedEntity());
        if (sameEntityType && originalData.equals((Object)transformedData)) {
            AgeingMobs.LOGGER.error("Aged Entity NBT identical to the original: {}", (Object)info.getName());
            return;
        }
        boolean bl = matchesOriginalData = originalData.isEmpty() || NbtUtils.compareNbt((Tag)originalData, (Tag)entityTag, (boolean)true);
        if (matchesOriginalData) {
            if (sameEntityType) {
                if (transformedData.isEmpty() || !NbtUtils.compareNbt((Tag)transformedData, (Tag)entityTag, (boolean)true)) {
                    this.extraChecks(info, entity, level);
                }
            } else {
                this.extraChecks(info, entity, level);
            }
        }
    }

    public void extraChecks(AgeingData info, Entity entity, Level level) {
        if (ModList.get().isLoaded("gamestages") && !info.getGamestage().isEmpty()) {
            if (GamestagesHandler.gamestageChecks(info, entity, level)) {
                this.checkCriteria(info, entity, level);
            }
        } else {
            this.checkCriteria(info, entity, level);
        }
    }

    public void checkCriteria(AgeingData info, Entity entity, Level level) {
        boolean ableToAge = true;
        for (BaseCriteria criteria : info.getCriteria()) {
            if (criteria.isReversing()) {
                this.babifyTheMob(info, entity);
            }
            if (criteria.checkCriteria(level, entity)) continue;
            ableToAge = false;
            break;
        }
        if (ableToAge) {
            this.ageTheMob(info, entity, level);
        }
    }

    public void ageTheMob(AgeingData info, Entity entity, Level level) {
        int maxTime = info.getAgeingTme();
        String uniqueTag = "ageingmobs:" + info.getName();
        CompoundTag tag = entity.getPersistentData();
        if (!tag.contains(uniqueTag)) {
            tag.putInt(uniqueTag, 0);
        }
        if (tag.getIntOr(uniqueTag, 0) >= maxTime) {
            if (info.getEntity().equals(info.getTransformedEntity())) {
                if (!info.getTransformedEntityData().isEmpty()) {
                    Entity agedEntity = info.getTransformedEntity().create(level, EntitySpawnReason.CONVERSION);
                    if (agedEntity != null) {
                        tag.remove(uniqueTag);
                        if (!this.canConvert(entity, agedEntity)) {
                            return;
                        }
                        this.callConversionEvent(entity, agedEntity);
                        agedEntity.copyPosition(entity);
                        this.copyEquipment(entity, agedEntity);
                        CompoundTag entityTag = AgeingRegistry.entityToNBT(entity);
                        CompoundTag entityTagCopy = entityTag.copy();
                        CompoundTag entityTag2 = info.getTransformedEntityData();
                        if (!entityTag2.isEmpty()) {
                            entityTagCopy.merge(entityTag2);
                            UUID uuid = agedEntity.getUUID();
                            try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(AgeingMobs.LOGGER);){
                                TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)agedEntity.registryAccess());
                                CompoundTag outputCompound = output.buildResult();
                                outputCompound.merge(entityTagCopy);
                                agedEntity.load(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)agedEntity.registryAccess(), (CompoundTag)outputCompound));
                            }
                            agedEntity.setUUID(uuid);
                        }
                        level.addFreshEntity(agedEntity);
                    } else {
                        AgeingMobs.LOGGER.error("An error has occured. Aged Entity is null, can not create entity with resource location: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(info.getTransformedEntity()));
                    }
                    entity.captureDrops(null);
                    entity.discard();
                }
            } else if (!info.getTransformedEntityData().isEmpty()) {
                Entity agedEntity = info.getTransformedEntity().create(level, EntitySpawnReason.CONVERSION);
                if (agedEntity != null) {
                    tag.remove(uniqueTag);
                    if (!this.canConvert(entity, agedEntity)) {
                        return;
                    }
                    this.callConversionEvent(entity, agedEntity);
                    agedEntity.copyPosition(entity);
                    this.copyEquipment(entity, agedEntity);
                    CompoundTag entityTag = AgeingRegistry.entityToNBT(entity);
                    CompoundTag entityTagCopy = entityTag.copy();
                    CompoundTag entityTag2 = info.getTransformedEntityData();
                    if (!entityTag2.isEmpty()) {
                        UUID uuid = agedEntity.getUUID();
                        entityTagCopy.merge(entityTag2);
                        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(AgeingMobs.LOGGER);){
                            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)agedEntity.registryAccess());
                            CompoundTag outputCompound = output.buildResult();
                            outputCompound.merge(entityTag);
                            agedEntity.load(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)agedEntity.registryAccess(), (CompoundTag)outputCompound));
                        }
                        agedEntity.setUUID(uuid);
                    }
                    level.addFreshEntity(agedEntity);
                } else {
                    AgeingMobs.LOGGER.error("An error has occured. Aged Entity is null, can not create entity with resource location: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(info.getTransformedEntity()));
                }
                entity.captureDrops(null);
                entity.discard();
            } else {
                Entity agedEntity = info.getTransformedEntity().create(level, EntitySpawnReason.CONVERSION);
                if (agedEntity != null) {
                    tag.remove(uniqueTag);
                    if (!this.canConvert(entity, agedEntity)) {
                        return;
                    }
                    this.callConversionEvent(entity, agedEntity);
                    agedEntity.copyPosition(entity);
                    this.copyEquipment(entity, agedEntity);
                    level.addFreshEntity(agedEntity);
                } else {
                    AgeingMobs.LOGGER.error("An error has occured. Aged Entity is null, can not create entity with resource location: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(info.getTransformedEntity()));
                }
                entity.captureDrops(null);
                entity.discard();
            }
        } else {
            int currentAge = tag.getIntOr(uniqueTag, 0);
            tag.putInt(uniqueTag, ++currentAge);
        }
    }

    private boolean canConvert(Entity entity, Entity agedEntity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (agedEntity instanceof LivingEntity) {
                return EventHooks.canLivingConvert((LivingEntity)livingEntity, (EntityType)agedEntity.getType(), timer -> {});
            }
        }
        return true;
    }

    private void callConversionEvent(Entity entity, Entity agedEntity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (agedEntity instanceof LivingEntity) {
                LivingEntity outcome = (LivingEntity)agedEntity;
                EventHooks.onLivingConvert((LivingEntity)livingEntity, (LivingEntity)outcome);
            }
        }
    }

    public void babifyTheMob(AgeingData info, Entity entity) {
        String uniqueTag = "ageingmobs:" + info.getName();
        CompoundTag tag = entity.getPersistentData();
        if (tag.contains(uniqueTag)) {
            int currentAge = tag.getIntOr(uniqueTag, 0);
            if (currentAge >= 0) {
                tag.putInt(uniqueTag, --currentAge);
            } else {
                tag.remove(uniqueTag);
            }
        }
    }

    public void copyEquipment(Entity original, Entity changedEntity) {
        if (original instanceof Mob) {
            Mob originalMob = (Mob)original;
            if (changedEntity instanceof Mob) {
                Mob changedMob = (Mob)changedEntity;
                changedMob.setItemSlot(EquipmentSlot.MAINHAND, originalMob.getItemBySlot(EquipmentSlot.MAINHAND));
                changedMob.setItemSlot(EquipmentSlot.OFFHAND, originalMob.getItemBySlot(EquipmentSlot.OFFHAND));
                changedMob.setItemSlot(EquipmentSlot.HEAD, originalMob.getItemBySlot(EquipmentSlot.HEAD));
                changedMob.setItemSlot(EquipmentSlot.CHEST, originalMob.getItemBySlot(EquipmentSlot.CHEST));
                changedMob.setItemSlot(EquipmentSlot.LEGS, originalMob.getItemBySlot(EquipmentSlot.LEGS));
                changedMob.setItemSlot(EquipmentSlot.FEET, originalMob.getItemBySlot(EquipmentSlot.FEET));
            }
        }
    }
}

