/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.shynieke.ageingmobs.AgeingMobs;
import com.shynieke.ageingmobs.config.AgeingConfig;
import com.shynieke.ageingmobs.registry.ageing.AgeingData;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.BiomeTypeCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.BlockBasedCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.BossCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.DimensionCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.EntityStateCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.LightCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.MagicCriteria;
import com.shynieke.ageingmobs.registry.ageing.criteria.WeatherCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.Tags;

public class AgeingRegistry {
    public static AgeingRegistry INSTANCE = new AgeingRegistry();
    public static LinkedHashMap<ResourceLocation, List<AgeingData>> ageingList = new LinkedHashMap();
    private static HashMap<Block, Double> importanceList = new HashMap();
    private static List<ResourceLocation> moonDimensions = Lists.newArrayList();

    public void initializeAgeing() {
        int maxLight;
        int minLight;
        LightCriteria lightCriteria;
        BaseCriteria[] criterias;
        int ageingTime;
        boolean criteriaChanged;
        boolean ageingChanged;
        int ageingTime2;
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.CREEPER), "CreeperToCharged") && ((Boolean)AgeingConfig.COMMON.creeperAgeing.get()).booleanValue()) {
            creeperToCharged = new AgeingData("CreeperToCharged", (EntityType<? extends Entity>)EntityType.CREEPER, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.CREEPER, AgeingRegistry.createNBTTag("{powered:1b}"), (Integer)AgeingConfig.COMMON.creeperAgeingTime.get());
            creeperToCharged.setCriteria(new BaseCriteria[]{new WeatherCriteria(creeperToCharged, "thunder")});
            INSTANCE.registerAgeing(creeperToCharged);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.CREEPER), "CreeperToCharged")) {
            creeperToCharged = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.CREEPER), "CreeperToCharged");
            ageingTime2 = (Integer)AgeingConfig.COMMON.creeperAgeingTime.get();
            if (creeperToCharged.getAgeingTme() != ageingTime2) {
                creeperToCharged.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(creeperToCharged);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE), "ZombieToHusk") && ((Boolean)AgeingConfig.COMMON.zombieToHuskAgeing.get()).booleanValue()) {
            zombieToHusk = new AgeingData("ZombieToHusk", (EntityType<? extends Entity>)EntityType.ZOMBIE, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.HUSK, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.zombieToHuskAgeingTime.get());
            zombieToHusk.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria((iAgeing)zombieToHusk, (TagKey<Biome>)Tags.Biomes.IS_HOT)});
            INSTANCE.registerAgeing(zombieToHusk);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE), "ZombieToHusk")) {
            zombieToHusk = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE), "ZombieToHusk");
            ageingTime2 = (Integer)AgeingConfig.COMMON.zombieToHuskAgeingTime.get();
            if (zombieToHusk.getAgeingTme() != ageingTime2) {
                zombieToHusk.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(zombieToHusk);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE), "BabyZombieToBabyHusk") && ((Boolean)AgeingConfig.COMMON.zombieToHuskAgeing.get()).booleanValue()) {
            babyZombieToBabyHusk = new AgeingData("BabyZombieToBabyHusk", (EntityType<? extends Entity>)EntityType.ZOMBIE, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.HUSK, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (Integer)AgeingConfig.COMMON.zombieToHuskAgeingTime.get());
            babyZombieToBabyHusk.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria((iAgeing)babyZombieToBabyHusk, (TagKey<Biome>)Tags.Biomes.IS_HOT)});
            INSTANCE.registerAgeing(babyZombieToBabyHusk);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE), "BabyZombieToBabyHusk")) {
            babyZombieToBabyHusk = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE), "BabyZombieToBabyHusk");
            ageingTime2 = (Integer)AgeingConfig.COMMON.zombieToHuskAgeingTime.get();
            if (babyZombieToBabyHusk.getAgeingTme() != ageingTime2) {
                babyZombieToBabyHusk.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyZombieToBabyHusk);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK), "HuskToZombie") && ((Boolean)AgeingConfig.COMMON.huskToZombieAgeing.get()).booleanValue()) {
            huskToZombie = new AgeingData("HuskToZombie", (EntityType<? extends Entity>)EntityType.HUSK, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.ZOMBIE, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.huskToZombieAgeingTime.get());
            huskToZombie.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria((iAgeing)huskToZombie, (TagKey<Biome>)Tags.Biomes.IS_COLD)});
            INSTANCE.registerAgeing(huskToZombie);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK), "HuskToZombie")) {
            huskToZombie = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK), "HuskToZombie");
            ageingTime2 = (Integer)AgeingConfig.COMMON.huskToZombieAgeingTime.get();
            if (huskToZombie.getAgeingTme() != ageingTime2) {
                huskToZombie.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(huskToZombie);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK), "BabyHuskToBabyZombie") && ((Boolean)AgeingConfig.COMMON.huskToZombieAgeing.get()).booleanValue()) {
            babyHuskToBabyZombie = new AgeingData("BabyHuskToBabyZombie", (EntityType<? extends Entity>)EntityType.HUSK, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.ZOMBIE, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (Integer)AgeingConfig.COMMON.huskToZombieAgeingTime.get());
            babyHuskToBabyZombie.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria((iAgeing)babyHuskToBabyZombie, (TagKey<Biome>)Tags.Biomes.IS_COLD)});
            INSTANCE.registerAgeing(babyHuskToBabyZombie);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK), "BabyHuskToBabyZombie")) {
            babyHuskToBabyZombie = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK), "BabyHuskToBabyZombie");
            ageingTime2 = (Integer)AgeingConfig.COMMON.huskToZombieAgeingTime.get();
            if (babyHuskToBabyZombie.getAgeingTme() != ageingTime2) {
                babyHuskToBabyZombie.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyHuskToBabyZombie);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.PILLAGER), "PassivePillagerToVillager") && ((Boolean)AgeingConfig.COMMON.passivePillagerToVillagerAgeing.get()).booleanValue()) {
            passivePillagerToVillager = new AgeingData("PassivePillagerToVillager", (EntityType<? extends Entity>)EntityType.PILLAGER, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.VILLAGER, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.passivePillagerToVillagerAgeingTime.get());
            passivePillagerToVillager.setCriteria(new BaseCriteria[]{new EntityStateCriteria(passivePillagerToVillager, entity -> {
                LivingEntity living;
                return entity instanceof LivingEntity && !(living = (LivingEntity)entity).isHolding(stack -> stack.getItem() instanceof CrossbowItem);
            })});
            INSTANCE.registerAgeing(passivePillagerToVillager);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.PILLAGER), "PassivePillagerToVillager")) {
            passivePillagerToVillager = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.PILLAGER), "PassivePillagerToVillager");
            ageingTime2 = (Integer)AgeingConfig.COMMON.passivePillagerToVillagerAgeingTime.get();
            if (passivePillagerToVillager.getAgeingTme() != ageingTime2) {
                passivePillagerToVillager.setAgeingTme(ageingTime2);
                INSTANCE.registerAgeing(passivePillagerToVillager);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.VILLAGER), "VillagerToVindicator") && ((Boolean)AgeingConfig.COMMON.villagerToVindicatorAgeing.get()).booleanValue()) {
            villagerToVindicator = new AgeingData("VillagerToVindicator", (EntityType<? extends Entity>)EntityType.VILLAGER, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.VINDICATOR, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.villagerToVindicatorAgeingTime.get());
            villagerToVindicator.setCriteria(new BaseCriteria[]{new LightCriteria(villagerToVindicator, (Integer)AgeingConfig.COMMON.villagerToVindicatorMinLight.get(), (Integer)AgeingConfig.COMMON.villagerToVindicatorMaxLight.get(), false, true)});
            INSTANCE.registerAgeing(villagerToVindicator);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.VILLAGER), "VillagerToVindicator")) {
            villagerToVindicator = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.VILLAGER), "VillagerToVindicator");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.COMMON.villagerToVindicatorAgeingTime.get();
            if (villagerToVindicator.getAgeingTme() != ageingTime) {
                villagerToVindicator.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = villagerToVindicator.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof LightCriteria)) continue;
                    lightCriteria = (LightCriteria)criteria;
                    minLight = (Integer)AgeingConfig.COMMON.villagerToVindicatorMinLight.get();
                    maxLight = (Integer)AgeingConfig.COMMON.villagerToVindicatorMaxLight.get();
                    if (lightCriteria.getLightLevelMin() != minLight) {
                        lightCriteria.setLightLevelMin(minLight);
                        criteriaChanged = true;
                    }
                    if (lightCriteria.getLightLevelMax() == maxLight) continue;
                    lightCriteria.setLightLevelMax(maxLight);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                villagerToVindicator.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(villagerToVindicator);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.VINDICATOR), "VindicatorToEvoker") && ((Boolean)AgeingConfig.COMMON.vindicatorToEvokerAgeing.get()).booleanValue()) {
            vindicatorToEvoker = new AgeingData("VindicatorToEvoker", (EntityType<? extends Entity>)EntityType.VINDICATOR, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.EVOKER, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.vindicatorToEvokerAgeingTime.get());
            vindicatorToEvoker.setCriteria(new BaseCriteria[]{new MagicCriteria(vindicatorToEvoker, 5)});
            INSTANCE.registerAgeing(vindicatorToEvoker);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.VINDICATOR), "VindicatorToEvoker")) {
            vindicatorToEvoker = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.VINDICATOR), "VindicatorToEvoker");
            ageingTime2 = (Integer)AgeingConfig.COMMON.vindicatorToEvokerAgeingTime.get();
            if (vindicatorToEvoker.getAgeingTme() != ageingTime2) {
                vindicatorToEvoker.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(vindicatorToEvoker);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.GUARDIAN), "GuardianToElder") && ((Boolean)AgeingConfig.COMMON.guardianToElderAgeing.get()).booleanValue()) {
            guardianToElder = new AgeingData("GuardianToElder", (EntityType<? extends Entity>)EntityType.GUARDIAN, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.ELDER_GUARDIAN, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.guardianToElderAgeingTime.get());
            guardianToElder.setCriteria(new BaseCriteria[]{new BossCriteria(guardianToElder, (Integer)AgeingConfig.COMMON.guardianToElderAgeingMax.get(), (Integer)AgeingConfig.COMMON.guardianToElderRange.get())});
            INSTANCE.registerAgeing(guardianToElder);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.GUARDIAN), "GuardianToElder")) {
            guardianToElder = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.GUARDIAN), "GuardianToElder");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.COMMON.guardianToElderAgeingTime.get();
            if (guardianToElder.getAgeingTme() != ageingTime) {
                guardianToElder.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = guardianToElder.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof BossCriteria)) continue;
                    BossCriteria bossCriteria = (BossCriteria)criteria;
                    int ageingMax = (Integer)AgeingConfig.COMMON.guardianToElderAgeingMax.get();
                    int range = (Integer)AgeingConfig.COMMON.guardianToElderRange.get();
                    if (bossCriteria.getMaxInArea() != ageingMax) {
                        bossCriteria.setMaxInArea(ageingMax);
                        criteriaChanged = true;
                    }
                    if (bossCriteria.getCheckRadius() == range) continue;
                    bossCriteria.setCheckRadius(range);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                guardianToElder.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(guardianToElder);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE), "BabyToZombie") && ((Boolean)AgeingConfig.COMMON.babyToZombieAgeing.get()).booleanValue()) {
            INSTANCE.registerAgeing(new AgeingData("BabyToZombie", (EntityType<? extends Entity>)EntityType.ZOMBIE, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.ZOMBIE, AgeingRegistry.createNBTTag("{IsBaby:0b}"), (Integer)AgeingConfig.COMMON.babyToZombieAgeingTime.get()));
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE), "BabyToZombie")) {
            AgeingData babyToZombie = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE), "BabyToZombie");
            ageingTime2 = (Integer)AgeingConfig.COMMON.babyToZombieAgeingTime.get();
            if (babyToZombie.getAgeingTme() != ageingTime2) {
                babyToZombie.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyToZombie);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK), "BabyToHusk") && ((Boolean)AgeingConfig.COMMON.babyToZombieAgeing.get()).booleanValue()) {
            INSTANCE.registerAgeing(new AgeingData("BabyToHusk", (EntityType<? extends Entity>)EntityType.HUSK, AgeingRegistry.createNBTTag("{IsBaby:1b}"), (EntityType<? extends Entity>)EntityType.HUSK, AgeingRegistry.createNBTTag("{IsBaby:0b}"), (Integer)AgeingConfig.COMMON.babyToZombieAgeingTime.get()));
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK), "BabyToHusk")) {
            AgeingData babyToHusk = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.HUSK), "BabyToHusk");
            ageingTime2 = (Integer)AgeingConfig.COMMON.babyToZombieAgeingTime.get();
            if (babyToHusk.getAgeingTme() != ageingTime2) {
                babyToHusk.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(babyToHusk);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SKELETON), "SkeletonToStray") && ((Boolean)AgeingConfig.COMMON.skeletonToStrayAgeing.get()).booleanValue()) {
            skeletonToStray = new AgeingData("SkeletonToStray", (EntityType<? extends Entity>)EntityType.SKELETON, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.STRAY, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.skeletonToStrayAgeingTime.get());
            skeletonToStray.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria((iAgeing)skeletonToStray, (TagKey<Biome>)Tags.Biomes.IS_COLD)});
            INSTANCE.registerAgeing(skeletonToStray);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SKELETON), "SkeletonToStray")) {
            skeletonToStray = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SKELETON), "SkeletonToStray");
            ageingTime2 = (Integer)AgeingConfig.COMMON.skeletonToStrayAgeingTime.get();
            if (skeletonToStray.getAgeingTme() != ageingTime2) {
                skeletonToStray.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(skeletonToStray);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.STRAY), "StrayToSkeleton") && ((Boolean)AgeingConfig.COMMON.strayToSkeletonAgeing.get()).booleanValue()) {
            strayToSkeleton = new AgeingData("StrayToSkeleton", (EntityType<? extends Entity>)EntityType.STRAY, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.SKELETON, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.strayToSkeletonAgeingTime.get());
            strayToSkeleton.setCriteria(new BaseCriteria[]{new BiomeTypeCriteria((iAgeing)strayToSkeleton, (TagKey<Biome>)Tags.Biomes.IS_HOT)});
            INSTANCE.registerAgeing(strayToSkeleton);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.STRAY), "StrayToSkeleton")) {
            strayToSkeleton = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.STRAY), "StrayToSkeleton");
            ageingTime2 = (Integer)AgeingConfig.COMMON.strayToSkeletonAgeingTime.get();
            if (strayToSkeleton.getAgeingTme() != ageingTime2) {
                strayToSkeleton.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(strayToSkeleton);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.RABBIT), "RabbitToKiller") && ((Boolean)AgeingConfig.COMMON.rabbitToKillerAgeing.get()).booleanValue()) {
            rabbitToKiller = new AgeingData("RabbitToKiller", (EntityType<? extends Entity>)EntityType.RABBIT, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.RABBIT, AgeingRegistry.createNBTTag("{RabbitType:99}"), (Integer)AgeingConfig.COMMON.rabbitToKillerAgeingTime.get());
            rabbitToKiller.setCriteria(new BaseCriteria[]{new LightCriteria(rabbitToKiller, (Integer)AgeingConfig.COMMON.rabbitToKillerMinLight.get(), (Integer)AgeingConfig.COMMON.rabbitToKillerMaxLight.get(), true, false)});
            INSTANCE.registerAgeing(rabbitToKiller);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.RABBIT), "RabbitToKiller")) {
            rabbitToKiller = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.RABBIT), "RabbitToKiller");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.COMMON.rabbitToKillerAgeingTime.get();
            if (rabbitToKiller.getAgeingTme() != ageingTime) {
                rabbitToKiller.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = rabbitToKiller.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof LightCriteria)) continue;
                    lightCriteria = (LightCriteria)criteria;
                    minLight = (Integer)AgeingConfig.COMMON.rabbitToKillerMinLight.get();
                    maxLight = (Integer)AgeingConfig.COMMON.rabbitToKillerMaxLight.get();
                    if (lightCriteria.getLightLevelMin() != minLight) {
                        lightCriteria.setLightLevelMin(minLight);
                        criteriaChanged = true;
                    }
                    if (lightCriteria.getLightLevelMax() == maxLight) continue;
                    lightCriteria.setLightLevelMax(maxLight);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                rabbitToKiller.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(rabbitToKiller);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.COW), "CowToMooshroom") && ((Boolean)AgeingConfig.COMMON.cowToMooshroomAgeing.get()).booleanValue()) {
            cowToMooshroom = new AgeingData("CowToMooshroom", (EntityType<? extends Entity>)EntityType.COW, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.MOOSHROOM, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.cowToMooshroomAgeingTime.get());
            cowToMooshroom.setCriteria(new BaseCriteria[]{new BlockBasedCriteria(cowToMooshroom, new Block[]{Blocks.MYCELIUM, Blocks.BROWN_MUSHROOM, Blocks.BROWN_MUSHROOM_BLOCK, Blocks.RED_MUSHROOM, Blocks.RED_MUSHROOM_BLOCK}, false, (Integer)AgeingConfig.COMMON.cowToMooshroomAgeingRadius.get())});
            INSTANCE.registerAgeing(cowToMooshroom);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.COW), "CowToMooshroom")) {
            cowToMooshroom = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.COW), "CowToMooshroom");
            ageingChanged = false;
            criteriaChanged = false;
            ageingTime = (Integer)AgeingConfig.COMMON.cowToMooshroomAgeingTime.get();
            if (cowToMooshroom.getAgeingTme() != ageingTime) {
                cowToMooshroom.setAgeingTme(ageingTime);
                ageingChanged = true;
            }
            if ((criterias = cowToMooshroom.getCriteria()).length > 0) {
                for (BaseCriteria criteria : criterias) {
                    if (!(criteria instanceof BlockBasedCriteria)) continue;
                    BlockBasedCriteria blockCriteria = (BlockBasedCriteria)criteria;
                    int radius = (Integer)AgeingConfig.COMMON.cowToMooshroomAgeingRadius.get();
                    if (blockCriteria.getRadius() == radius) continue;
                    blockCriteria.setRadius(radius);
                    criteriaChanged = true;
                }
            }
            if (criteriaChanged) {
                cowToMooshroom.setCriteria(criterias);
            }
            if (ageingChanged || criteriaChanged) {
                INSTANCE.replaceAgeing(cowToMooshroom);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SKELETON), "SkeletonToWitherSkelly") && ((Boolean)AgeingConfig.COMMON.skeletonToWitherSkeletonAgeing.get()).booleanValue()) {
            skeletonToWitherSkelly = new AgeingData("SkeletonToWitherSkelly", (EntityType<? extends Entity>)EntityType.SKELETON, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.WITHER_SKELETON, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.skeletonToWitherSkeletonAgeingTime.get());
            skeletonToWitherSkelly.setCriteria(new BaseCriteria[]{new DimensionCriteria(skeletonToWitherSkelly, new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"the_nether")})});
            INSTANCE.registerAgeing(skeletonToWitherSkelly);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SKELETON), "SkeletonToWitherSkelly")) {
            skeletonToWitherSkelly = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SKELETON), "SkeletonToWitherSkelly");
            ageingTime2 = (Integer)AgeingConfig.COMMON.skeletonToWitherSkeletonAgeingTime.get();
            if (skeletonToWitherSkelly.getAgeingTme() != ageingTime2) {
                skeletonToWitherSkelly.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(skeletonToWitherSkelly);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SLIME), "SlimeToMagmaCube") && ((Boolean)AgeingConfig.COMMON.slimeToMagmaCubeAgeing.get()).booleanValue()) {
            slimeToMagmaCube = new AgeingData("SlimeToMagmaCube", (EntityType<? extends Entity>)EntityType.SLIME, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.MAGMA_CUBE, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.slimeToMagmaCubeAgeingTime.get());
            slimeToMagmaCube.setCriteria(new BaseCriteria[]{new DimensionCriteria(slimeToMagmaCube, new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"the_nether")})});
            INSTANCE.registerAgeing(slimeToMagmaCube);
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SLIME), "SlimeToMagmaCube")) {
            slimeToMagmaCube = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.SLIME), "SlimeToMagmaCube");
            ageingTime2 = (Integer)AgeingConfig.COMMON.slimeToMagmaCubeAgeingTime.get();
            if (slimeToMagmaCube.getAgeingTme() != ageingTime2) {
                slimeToMagmaCube.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(slimeToMagmaCube);
            }
        }
        if (INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.BAT), "BatToVex") && ((Boolean)AgeingConfig.COMMON.batToVexAgeing.get()).booleanValue()) {
            INSTANCE.registerAgeing(new AgeingData("BatToVex", (EntityType<? extends Entity>)EntityType.BAT, AgeingRegistry.createNBTTag(""), (EntityType<? extends Entity>)EntityType.VEX, AgeingRegistry.createNBTTag(""), (Integer)AgeingConfig.COMMON.batToVexAgeingTime.get()));
        } else if (!INSTANCE.isIDUnique(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.BAT), "BatToVex")) {
            AgeingData batToVex = INSTANCE.getByID(BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.BAT), "BatToVex");
            ageingTime2 = (Integer)AgeingConfig.COMMON.batToVexAgeingTime.get();
            if (batToVex.getAgeingTme() != ageingTime2) {
                batToVex.setAgeingTme(ageingTime2);
                INSTANCE.replaceAgeing(batToVex);
            }
        }
    }

    public void registerAgeing(AgeingData ageing) {
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey(ageing.getEntity());
        if (resourceLocation != null) {
            if (ageingList.containsKey(resourceLocation)) {
                ArrayList<AgeingData> dataList = new ArrayList<AgeingData>((Collection)ageingList.get(resourceLocation));
                dataList.add(ageing);
                ageingList.put(resourceLocation, dataList);
            } else {
                ageingList.put(resourceLocation, Collections.singletonList(ageing));
            }
        } else {
            AgeingMobs.LOGGER.error(String.format("Failed to add Ageing Data with ID %s because the entity's resourcelocation is null", ageing.getName()));
        }
    }

    public void removeAgeing(AgeingData ageing) {
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey(ageing.getEntity());
        if (resourceLocation != null) {
            if (ageingList.containsKey(resourceLocation)) {
                ArrayList dataList = new ArrayList(ageingList.get(resourceLocation));
                dataList.remove(ageing);
                if (dataList.isEmpty()) {
                    ageingList.remove(resourceLocation);
                } else {
                    ageingList.put(resourceLocation, dataList);
                }
            } else {
                AgeingMobs.LOGGER.error(String.format("Tried to remove Ageing Data with id %s but it didn't exist", ageing.getName()));
            }
        } else {
            AgeingMobs.LOGGER.error(String.format("Failed to remove Ageing Data with ID %s because the entity's resourcelocation is null", ageing.getName()));
        }
    }

    public void replaceAgeing(AgeingData ageing) {
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey(ageing.getEntity());
        String uniqueID = ageing.getName();
        if (resourceLocation != null) {
            if (ageingList.containsKey(resourceLocation)) {
                ArrayList dataList = ageingList.get(resourceLocation);
                if (dataList == null) {
                    dataList = Lists.newArrayList();
                }
                boolean found = false;
                if (!dataList.isEmpty()) {
                    ListIterator<AgeingData> iterator = dataList.listIterator();
                    while (iterator.hasNext()) {
                        AgeingData data = (AgeingData)iterator.next();
                        if (!data.getName().equals(uniqueID)) continue;
                        iterator.set(ageing);
                        found = true;
                    }
                    if (!found) {
                        AgeingMobs.LOGGER.error(String.format("Tried to change Ageing Data with id %s but it didn't exist", ageing.getName()));
                    }
                }
            }
        } else {
            AgeingMobs.LOGGER.error(String.format("Failed to remove Ageing Data with ID %s because the entity's resourcelocation is null", ageing.getName()));
        }
    }

    public static List<AgeingData> getDataList(ResourceLocation resourceLocation) {
        if (ageingList.containsKey(resourceLocation)) {
            List<AgeingData> dataList = ageingList.get(resourceLocation);
            if (dataList == null) {
                return new ArrayList<AgeingData>();
            }
            return dataList;
        }
        return new ArrayList<AgeingData>();
    }

    public static boolean hasEntityAgeing(ResourceLocation resourceLocation) {
        return ageingList.containsKey(resourceLocation);
    }

    public AgeingData getByID(ResourceLocation resourceLocation, String uniqueID) {
        if (ageingList.containsKey(resourceLocation)) {
            ArrayList dataList = ageingList.get(resourceLocation);
            if (dataList == null) {
                dataList = Lists.newArrayList();
            }
            if (!dataList.isEmpty()) {
                for (AgeingData data : dataList) {
                    if (!data.getName().equals(uniqueID)) continue;
                    return data;
                }
            }
        }
        return null;
    }

    public AgeingData getByID(String uniqueID) {
        for (Map.Entry<ResourceLocation, List<AgeingData>> entry : ageingList.entrySet()) {
            List<AgeingData> dataList = entry.getValue();
            if (dataList == null || dataList.isEmpty()) continue;
            for (AgeingData data : dataList) {
                if (!data.getName().equals(uniqueID)) continue;
                return data;
            }
        }
        return null;
    }

    public boolean isIDUnique(ResourceLocation resourceLocation, String uniqueID) {
        if (ageingList.containsKey(resourceLocation)) {
            ArrayList dataList = ageingList.get(resourceLocation);
            if (dataList == null) {
                dataList = Lists.newArrayList();
            }
            if (!dataList.isEmpty()) {
                for (AgeingData data : dataList) {
                    if (!data.getName().equals(uniqueID)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static CompoundTag createNBTTag(String nbtData) {
        CompoundTag tag = new CompoundTag();
        try {
            tag = nbtData.startsWith("{") && nbtData.endsWith("}") ? TagParser.parseCompoundFully((String)nbtData) : TagParser.parseCompoundFully((String)("{" + nbtData + "}"));
        }
        catch (CommandSyntaxException nbtexception) {
            AgeingMobs.LOGGER.error("nope... {}", (Object)nbtexception.getMessage());
        }
        return tag;
    }

    public void initializeMagicMap() {
        List magicalBlocks = (List)AgeingConfig.COMMON.magical_blocks.get();
        if (!magicalBlocks.isEmpty()) {
            importanceList = new HashMap();
            for (String blockData : magicalBlocks) {
                String[] blockInfo = blockData.split(";");
                if (blockInfo.length > 2) {
                    AgeingMobs.LOGGER.error("An error has occured. {} is using the wrong syntax.", (Object)blockData);
                    continue;
                }
                if (blockInfo.length != 2) continue;
                String blockName = blockInfo[0];
                double importance = Double.parseDouble(blockInfo[1]);
                Optional blockHolder = BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse((String)blockName));
                if (!blockHolder.isPresent() || importanceList.containsKey(blockHolder.get())) continue;
                importanceList.put((Block)blockHolder.get(), importance);
            }
        }
    }

    public HashMap<Block, Double> getMagicMap() {
        return importanceList;
    }

    public void initializeMoonDimensions() {
        List dimensions = (List)AgeingConfig.COMMON.moon_dimensions.get();
        ArrayList<ResourceLocation> dimensionList = new ArrayList<ResourceLocation>();
        for (String string : dimensions) {
            ResourceLocation dim = ResourceLocation.tryParse((String)string);
            if (dimensionList.contains(dim)) continue;
            dimensionList.add(dim);
        }
        moonDimensions = dimensionList;
    }

    public List<ResourceLocation> getMoonDimensions() {
        return moonDimensions;
    }

    public static CompoundTag entityToNBT(Entity theEntity) {
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(AgeingMobs.LOGGER);){
            Player player;
            ItemStack itemstack;
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)theEntity.registryAccess());
            theEntity.saveWithoutId((ValueOutput)output);
            if (theEntity instanceof Player && !(itemstack = (player = (Player)theEntity).getInventory().getSelectedItem()).isEmpty()) {
                output.store("SelectedItem", ItemStack.OPTIONAL_CODEC, (Object)itemstack);
            }
            CompoundTag compoundTag = output.buildResult();
            return compoundTag;
        }
    }
}

