/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.google.common.collect.Lists;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class BlockBasedCriteria
extends BaseCriteria {
    private List<Block> block;
    private boolean nearBlock;
    private int radius;

    public BlockBasedCriteria(iAgeing ageing, Block[] block, Boolean nearBlock, int radius) {
        super(ageing);
        this.block = Lists.newArrayList((Object[])block);
        this.nearBlock = nearBlock;
        this.radius = radius;
    }

    public List<Block> getBlock() {
        return this.block;
    }

    public void setBlock(List<Block> block) {
        this.block = block;
    }

    public boolean isNearBlock() {
        return this.nearBlock;
    }

    public void setNearBlock(boolean nearBlock) {
        this.nearBlock = nearBlock;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public boolean checkCriteria(Level level, Entity entityIn) {
        BlockPos entityPos = entityIn.blockPosition();
        if (this.isNearBlock()) {
            int radius = this.getRadius();
            Iterator posIterator = BlockPos.betweenClosedStream((BlockPos)entityPos.offset(-radius, -radius, -radius), (BlockPos)entityPos.offset(radius, radius, radius)).iterator();
            while (posIterator.hasNext()) {
                BlockPos pos = (BlockPos)posIterator.next();
                if (!this.getBlock().contains(level.getBlockState(pos).getBlock())) continue;
                return true;
            }
            return false;
        }
        return this.getBlock().contains(level.getBlockState(entityPos.below()).getBlock());
    }
}

