/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class BossCriteria
extends BaseCriteria {
    private int maxInArea;
    private int checkRadius;
    private boolean isReversing;

    public BossCriteria(iAgeing ageing, int maxInArea, int checkRadius) {
        super(ageing);
        this.maxInArea = maxInArea;
        this.checkRadius = checkRadius;
        this.isReversing = false;
    }

    public int getMaxInArea() {
        return this.maxInArea;
    }

    public void setMaxInArea(int maxInArea) {
        this.maxInArea = maxInArea;
    }

    public int getCheckRadius() {
        return this.checkRadius;
    }

    public void setCheckRadius(int checkRadius) {
        this.checkRadius = checkRadius;
    }

    @Override
    public boolean checkCriteria(Level level, Entity entityIn) {
        BlockPos entityPos = entityIn.blockPosition();
        if (this.getMaxInArea() != 0) {
            int checkRadius = this.getCheckRadius();
            int bossAmount = 0;
            AABB areaHitbox = new AABB((double)((float)entityPos.getX() - 0.5f), (double)((float)entityPos.getY() - 0.5f), (double)((float)entityPos.getZ() - 0.5f), (double)((float)entityPos.getX() + 0.5f), (double)((float)entityPos.getY() + 0.5f), (double)((float)entityPos.getZ() + 0.5f)).expandTowards((double)(-checkRadius), (double)(-checkRadius), (double)(-checkRadius)).expandTowards((double)checkRadius, (double)checkRadius, (double)checkRadius);
            if (!level.getEntitiesOfClass(Entity.class, areaHitbox).isEmpty()) {
                for (Entity foundEntity : level.getEntitiesOfClass(Entity.class, areaHitbox)) {
                    if (foundEntity instanceof Player || !foundEntity.getType().equals(this.getTransformedEntity())) continue;
                    if (!this.getTransformedEntityData().isEmpty()) {
                        CompoundTag entityTag = AgeingRegistry.entityToNBT(foundEntity);
                        CompoundTag entityTag2 = this.getTransformedEntityData();
                        if (NbtUtils.compareNbt((Tag)entityTag2, (Tag)entityTag, (boolean)true)) continue;
                        ++bossAmount;
                        continue;
                    }
                    ++bossAmount;
                }
            }
            if (bossAmount < this.getMaxInArea()) {
                this.isReversing = false;
                return true;
            }
            this.isReversing = true;
            return false;
        }
        this.isReversing = false;
        return true;
    }

    @Override
    public boolean isReversing() {
        return this.isReversing;
    }
}

