/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EffectCriteria
extends BaseCriteria {
    private Holder<MobEffect> mobEffect;

    public EffectCriteria(iAgeing ageing, Holder<MobEffect> mobEffect) {
        super(ageing);
        this.mobEffect = mobEffect;
    }

    public EffectCriteria(iAgeing ageing, MobEffect mobEffect) {
        super(ageing);
        Optional optionalHolder;
        ResourceLocation effectLocation = BuiltInRegistries.MOB_EFFECT.getKey((Object)mobEffect);
        if (effectLocation != null) {
            optionalHolder = BuiltInRegistries.MOB_EFFECT.get(effectLocation);
            if (!optionalHolder.isPresent()) {
                throw new IllegalArgumentException("Unknown effect: " + String.valueOf(mobEffect));
            }
        } else {
            throw new IllegalArgumentException("Unknown effect: " + String.valueOf(mobEffect));
        }
        this.mobEffect = (Holder)optionalHolder.get();
    }

    public Holder<MobEffect> getMobEffect() {
        return this.mobEffect;
    }

    public void setMobEffect(Holder<MobEffect> mobEffect) {
        this.mobEffect = mobEffect;
    }

    @Override
    public boolean checkCriteria(Level level, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            return livingEntity.hasEffect(this.mobEffect);
        }
        return false;
    }
}

